/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.consensus;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.consensus.facade.CreateAgentReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.consensus.ConsensusBaseProcessor;
import io.nuls.core.core.annotation.Component;
import java.math.BigInteger;

@Component
public class CreateAgentProcessor
extends ConsensusBaseProcessor
implements CommandProcessor {
    @Override
    public String getCommand() {
        return "createagent";
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine(this.getCommandDescription()).newLine("\t<agentAddress>   agent owner address   -required").newLine("\t<packingAddress>    packing address    -required").newLine("\t<commissionRate>    commission rate (10~100), you can have up to 2 valid digits after the decimal point  -required").newLine("\t<deposit>   amount you want to deposit, you can have up to 8 valid digits after the decimal point -required").newLine("\t[rewardAddress]  Billing address    -not required");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "createagent <agentAddress> <packingAddress> <commissionRate> <deposit> [rewardAddress] --create a agent";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkIsNumeric(args[3], "commissionRate");
        this.checkArgs(() -> {
            BigInteger commission = new BigInteger(args[3]);
            return commission.compareTo(BigInteger.TEN) >= 0 && commission.compareTo(BigInteger.valueOf(100L)) <= 0;
        }, "commission rate (10~100)");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        CreateAgentReq req;
        Result result;
        String agentAddress = args[1];
        String password = this.getPwd("Enter agent address password:");
        String packingAddress = args[2];
        Integer commissionRate = Integer.parseInt(args[3]);
        BigInteger deposit = this.config.toSmallUnit(args[4]);
        String rewardAddress = null;
        if (args.length == 6) {
            rewardAddress = args[5];
        }
        if ((result = this.consensusProvider.createAgent(req = new CreateAgentReq(agentAddress, packingAddress, rewardAddress, commissionRate, deposit, password))).isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

