/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.contract;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.contract.facade.CallContractReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.contract.ContractBaseProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class CallContractProcessor
extends ContractBaseProcessor {
    private ThreadLocal<CallContractReq> paramsData = new ThreadLocal();

    @Override
    public String getCommand() {
        return "callcontract";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<sender>            source address    -required").newLine("\t<gasLimit>          gas limit    -required").newLine("\t<price>             price (Unit: Na/Gas)    -required").newLine("\t<contractAddress>   contract address    -required").newLine("\t<methodName>        the method to call    -required").newLine("\t<value>             transfer nuls to the contract (Unit: Nuls)    -required").newLine("\t[-d methodDesc]        the method description    -not required").newLine("\t[-r remark]            remark    -not required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "callcontract <sender> <gasLimit> <price> <contractAddress> <methodName> <value> [-d methodDesc] [-r remark] --call contract";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 6, 7, 8);
        this.checkAddress(this.config.getChainId(), args[1], args[4]);
        this.checkIsNumeric(args[2], "gasLimit");
        this.checkIsNumeric(args[3], "price");
        CallContractReq form = this.getContractCall(args);
        if (null == form) {
            return false;
        }
        this.paramsData.set(form);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CallContractReq getContractCall(String[] args) {
        CallContractReq call = null;
        try {
            call = new CallContractReq();
            call.setSender(args[1].trim());
            call.setGasLimit(Long.valueOf(args[2].trim()).longValue());
            call.setPrice(Long.valueOf(args[3].trim()).longValue());
            call.setContractAddress(args[4].trim());
            call.setMethodName(args[5].trim());
            long naValue = 0L;
            call.setValue(this.config.toSmallUnit(args[6]).longValue());
            if (args.length == 9) {
                String argType = args[7].trim();
                if ("-d".equals(argType)) {
                    call.setMethodDesc(args[8].trim());
                    return call;
                } else {
                    if (!"-r".equals(argType)) return null;
                    call.setRemark(args[8].trim());
                }
                return call;
            } else {
                if (args.length != 11) return call;
                String argType0 = args[7].trim();
                String argType1 = args[9].trim();
                boolean isType0D = "-d".equals(argType0);
                boolean isType1D = "-d".equals(argType1);
                boolean isType0R = "-r".equals(argType0);
                boolean isType1R = "-r".equals(argType1);
                if (isType0D && isType1D || isType0R && isType1R) {
                    return null;
                }
                if (isType0D) {
                    call.setMethodDesc(args[8].trim());
                }
                if (isType0R) {
                    call.setRemark(args[8].trim());
                }
                if (isType1D) {
                    call.setMethodDesc(args[10].trim());
                }
                if (!isType1R) return call;
                call.setRemark(args[10].trim());
            }
            return call;
        }
        catch (Exception e) {
            e.fillInStackTrace();
            return null;
        }
    }

    @Override
    public CommandResult execute(String[] args) {
        CallContractReq form = this.paramsData.get();
        if (null == form) {
            form = this.getContractCall(args);
        }
        if (null == form) {
            return CommandResult.getFailed("parameter error.");
        }
        String password = CommandHelper.getPwd();
        form.setArgs(this.getContractCallArgsJson());
        form.setPassword(password);
        Result result = this.contractProvider.callContract(form);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getResult(result);
    }
}

