/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.contract;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.contract.facade.GetAccountContractListReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.ErrorCodeConstants;
import io.nuls.cmd.client.processor.contract.ContractBaseProcessor;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;

@Component
public class GetAccountContractListProcessor
extends ContractBaseProcessor {
    @Override
    public String getCommand() {
        return "getaccountcontracts";
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine(this.getCommandDescription()).newLine("\t<address>  account address -required");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getaccountcontracts <address> --get contract list by account";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        this.checkAddress(this.config.getChainId(), args[1]);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String address = args[1];
        if (StringUtils.isBlank((String)address)) {
            return CommandResult.getFailed(ErrorCodeConstants.PARAM_ERR.getMsg());
        }
        Result result = this.contractProvider.getAccountContractList(new GetAccountContractListReq(address));
        return CommandResult.getResult(CommandResult.dataTransformList(result));
    }
}

