/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.contract;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.contract.facade.TransferToContractReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.ErrorCodeConstants;
import io.nuls.cmd.client.processor.contract.ContractBaseProcessor;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;
import java.math.BigInteger;

@Component
public class TransferToContractProcessor
extends ContractBaseProcessor {
    @Override
    public String getCommand() {
        return "transfertocontract";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address> address -required").newLine("\t<toAddress> toAddress -required").newLine("\t<amount> transfer amount -required").newLine("\t[remark] remark not -required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "transfertocontract <address> <toAddress> <amount> [remark] --create transfer to contract address";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 3, 4);
        this.checkAddress(this.config.getChainId(), args[1], args[2]);
        this.checkIsAmount(args[3], "amount");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String address = args[1];
        if (StringUtils.isBlank((String)address)) {
            return CommandResult.getFailed(ErrorCodeConstants.PARAM_ERR.getMsg());
        }
        String password = CommandHelper.getPwd();
        String toAddress = args[2];
        BigInteger amount = this.config.toSmallUnit(args[3]);
        TransferToContractReq req = new TransferToContractReq(address, toAddress, amount, password, null);
        Result result = this.contractProvider.transferToContract(req);
        if (args.length > 4) {
            req.setRemark(args[4]);
        }
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getResult(result);
    }
}

