/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.crosschain;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.crosschain.facade.DisableAssetReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.crosschain.CrossChainBaseProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class CrossAssetDisableProcessor
extends CrossChainBaseProcessor {
    @Override
    public String getCommand() {
        return "disablecrossasset";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address>  once register cross asset address - require").newLine("\t<chainId>  remove asset chainId - require").newLine("\t<assetId> remove assetId - require");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "disablecrossasset <address> <chainId> <assetId> --disable cross chain asset,disable the chain when assets are the last";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 3);
        this.checkAddress(this.config.getMainChainId(), args[1]);
        this.checkIsNumeric(args[2], "chainId");
        this.checkIsNumeric(args[3], "assetId");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Integer assetId;
        String address = args[1];
        Integer assetChainId = Integer.parseInt(args[2]);
        DisableAssetReq req = new DisableAssetReq(address, assetChainId, assetId = Integer.valueOf(Integer.parseInt(args[3])), this.getPwd());
        Result result = this.chainManageProvider.disableCrossAsset(req);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess((String)result.getData());
    }
}

