/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.crosschain;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.crosschain.facade.AddCrossLocalAssetReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.crosschain.CrossChainBaseProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class CrossLocalAssetAddProcessor
extends CrossChainBaseProcessor {
    @Override
    public String getCommand() {
        return "addcrosslocalasset";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<regAddress>  register cross asset address - require").newLine("\t<assetId> add assetId - require");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "addcrosslocalasset <regAddress> <assetId>--add cross local chain asset";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 2);
        this.checkAddress(this.config.getMainChainId(), args[1]);
        this.checkIsNumeric(args[2], "assetId");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String address = args[1];
        Integer assetId = Integer.parseInt(args[2]);
        AddCrossLocalAssetReq req = new AddCrossLocalAssetReq(address, assetId, this.getPwd());
        Result result = this.chainManageProvider.addCrossLocalAsset(req);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess((String)result.getData());
    }
}

