/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.crosschain;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.crosschain.facade.GetCrossAssetInfoReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.crosschain.CrossChainBaseProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class GetCrossAssetInfoProcessor
extends CrossChainBaseProcessor {
    @Override
    public String getCommand() {
        return "crossassetinfo";
    }

    @Override
    public String getHelp() {
        return new CommandBuilder().newLine(this.getCommandDescription()).newLine("\t<chainId>  register chain id - require").newLine("\t<assetId>  register asset id - require").toString();
    }

    @Override
    public String getCommandDescription() {
        return this.getCommand() + " <chainId> chain id - require";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 2);
        this.checkIsNumeric(args[1], "chainId");
        this.checkIsNumeric(args[2], "assetId");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Integer assetId;
        Integer chainId = Integer.parseInt(args[1]);
        Result result = this.chainManageProvider.getCrossAssetInfo(new GetCrossAssetInfoReq(chainId, assetId = Integer.valueOf(Integer.parseInt(args[2]))));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

