/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.crosschain;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.block.BlockService;
import io.nuls.base.api.provider.block.facade.BlockHeaderData;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByLastHeightReq;
import io.nuls.base.api.provider.crosschain.facade.RehandleCtxReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.crosschain.CrossChainBaseProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class RehandleCrossTxProcessor
extends CrossChainBaseProcessor {
    BlockService blockService = (BlockService)ServiceManager.get(BlockService.class);

    @Override
    public String getCommand() {
        return "rehandlectx";
    }

    @Override
    public String getHelp() {
        return new CommandBuilder().newLine(this.getCommandDescription()).newLine("\t<txHash>  tx hash - require").toString();
    }

    @Override
    public String getCommandDescription() {
        return this.getCommand() + " <txHash> ";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String txHash = args[1];
        long blockHeight = ((BlockHeaderData)this.blockService.getBlockHeaderByLastHeight(new GetBlockHeaderByLastHeightReq()).getData()).getHeight();
        Result result = this.crossChainProvider.rehandleCtx(new RehandleCtxReq(txHash, blockHeight));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess((String)result.getData());
    }
}

