/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.ledger;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.ledger.LedgerProvider;
import io.nuls.base.api.provider.ledger.facade.GetAssetReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;

@Component
public class GetLocalCrossAssetProcessor
implements CommandProcessor {
    LedgerProvider ledgerProvider = (LedgerProvider)ServiceManager.get(LedgerProvider.class);
    @Autowired
    Config config;

    @Override
    public String getCommand() {
        return "getLocalAsset";
    }

    @Override
    public CommandGroup getGroup() {
        return CommandGroup.Ledger;
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t[txHash] the asset create hash - require");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getLocalAsset txHash --get local asset info";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1, 1);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String txHash = args[1];
        Result result = this.ledgerProvider.getLocalAsset(new GetAssetReq(txHash));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

