/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.ledger;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.ledger.LedgerProvider;
import io.nuls.base.api.provider.ledger.facade.RegLocalAssetReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;

@Component
public class RegisterLocalAssetProcessor
implements CommandProcessor {
    @Autowired
    Config config;
    LedgerProvider ledgerProvider = (LedgerProvider)ServiceManager.get(LedgerProvider.class);

    @Override
    public CommandGroup getGroup() {
        return CommandGroup.Ledger;
    }

    @Override
    public String getCommand() {
        return "registerlocalasset";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<regAddress>  register asset address - require").newLine("\t<assetName> asset name - require").newLine("\t<symbol> asset symbol - require").newLine("\t<initNumber> asset init Number - require").newLine("\t<decimalPlace> asset decimal - require").newLine("\t<assetOwnerAddress> asset owner - require");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "registerlocalasset <regAddress> <assetName> <symbol> <initNumber> <decimalPlace> <assetOwnerAddress>--add local chain asset";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 6);
        this.checkAddress(this.config.getMainChainId(), args[1]);
        this.checkIsAmount(args[4], "initNumber");
        this.checkIsAmount(args[5], "decimalPlace");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String address = args[1];
        String assetName = args[2];
        String symbol = args[3];
        long initNumber = Long.valueOf(args[4]);
        int decimalPlaces = Integer.parseInt(args[5]);
        String assetOwnerAddress = args[6];
        RegLocalAssetReq req = new RegLocalAssetReq(address, symbol, assetName, initNumber, decimalPlaces, this.getPwd(), assetOwnerAddress);
        Result result = this.ledgerProvider.regLocalAsset(req);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

