/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.transaction;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.transaction.facade.CreateMultiSignTransferReq;
import io.nuls.base.api.provider.transaction.facade.TransferReq;
import io.nuls.base.basic.AddressTool;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.transaction.TransactionBaseProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import java.math.BigDecimal;
import java.math.BigInteger;

@Component
public class CreateMultiSignTransferProcessor
extends TransactionBaseProcessor
implements CommandProcessor {
    @Autowired
    Config config;

    @Override
    public String getCommand() {
        return "createmultisigntransfer";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address> \t\tsource address or alias - Required").newLine("\t<toaddress> \treceiving address or alias - Required").newLine("\t<amount> \t\tamount, you can have up to 8 valid digits after the decimal point - Required").newLine("\t[remark] \t\tremark - ");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "createmultisigntransfer <multi sign address> <toAddress>|<alias> <amount> [remark] ";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 3, 4);
        this.checkIsAmount(args[3], "amount");
        return true;
    }

    private CreateMultiSignTransferReq buildTransferReq(String[] args) {
        String formAddress = args[1];
        String toAddress = args[2];
        BigInteger amount = this.config.toSmallUnit(new BigDecimal(args[3]));
        TransferReq.TransferReqBuilder builder = new TransferReq.TransferReqBuilder(this.config.getChainId(), this.config.getAssetsId()).addForm(formAddress, null, amount).addTo(toAddress, amount);
        if (args.length == 5) {
            builder.setRemark(args[4]);
        }
        return (CreateMultiSignTransferReq)builder.build((TransferReq)new CreateMultiSignTransferReq());
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result = this.transferService.multiSignTransfer(this.buildTransferReq(args));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }

    public static void main(String[] args) {
        if (!AddressTool.validAddress((int)2, (String)"tNULSeBaNQM6FzaviJbzxQ8FkwtajaVhgrTvHT")) {
            System.out.println("fail");
        } else {
            System.out.println("success");
        }
    }
}

