/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.transaction;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.transaction.facade.TransferReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.transaction.TransactionBaseProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import java.math.BigDecimal;
import java.math.BigInteger;

@Component
public class TransferProcessor
extends TransactionBaseProcessor
implements CommandProcessor {
    @Autowired
    Config config;

    @Override
    public String getCommand() {
        return "transfer";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address> \t\tsource address or alias - Required").newLine("\t<toaddress> \treceiving address or alias - Required").newLine("\t<amount> \t\tamount - Required").newLine("\t[remark] \t\tremark - ").newLine("\t[password] \t\tpassword - ");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "transfer <address>|<alias> <toAddress>|<alias> <amount> [remark] [password] --transfer";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 3, 4);
        this.checkIsAmount(args[3], "amount");
        return true;
    }

    private TransferReq buildTransferReq(String[] args) {
        String formAddress = args[1];
        String toAddress = args[2];
        BigInteger amount = this.config.toSmallUnit(new BigDecimal(args[3]));
        String password = args.length == 6 ? args[5] : this.getPwd("\nEnter your account password:");
        TransferReq.TransferReqBuilder builder = new TransferReq.TransferReqBuilder(this.config.getChainId(), this.config.getAssetsId()).addForm(formAddress, password, amount).addTo(toAddress, amount);
        if (args.length == 5) {
            builder.setRemark(args[4]);
        }
        return builder.build(new TransferReq());
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result = this.transferService.transfer(this.buildTransferReq(args));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess((String)result.getData());
    }
}

