/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2;

import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.I18nUtils;
import io.nuls.v2.SDKContext;

public class NulsSDKBootStrap {
    private static final String LANGUAGE = "en";
    private static final String LANGUAGE_PATH = "languages";

    public static void init(int chainId, String httpUrl) {
        NulsSDKBootStrap.initChainId(chainId);
        if (httpUrl != null && !httpUrl.endsWith("/")) {
            httpUrl = httpUrl + "/";
        }
        if (StringUtils.isNotBlank((String)httpUrl)) {
            SDKContext.wallet_url = httpUrl;
        }
    }

    public static void init(int chainId, String addressPrefix, String httpUrl) {
        NulsSDKBootStrap.initChainId(chainId);
        if (httpUrl != null && !httpUrl.endsWith("/")) {
            httpUrl = httpUrl + "/";
        }
        if (StringUtils.isNotBlank((String)httpUrl)) {
            SDKContext.wallet_url = httpUrl;
        }
        SDKContext.addressPrefix = addressPrefix;
    }

    @Deprecated
    public static void init(int chainId, int nulsChainId, String addressPrefix, String httpUrl) {
        NulsSDKBootStrap.initChainId(chainId);
        if (httpUrl != null && !httpUrl.endsWith("/")) {
            httpUrl = httpUrl + "/";
        }
        if (StringUtils.isNotBlank((String)httpUrl)) {
            SDKContext.wallet_url = httpUrl;
        }
        SDKContext.main_chain_id = nulsChainId;
        SDKContext.addressPrefix = addressPrefix;
    }

    public static void initMain(String httpUrl) {
        NulsSDKBootStrap.initChainId(1);
        if (httpUrl != null && !httpUrl.endsWith("/")) {
            httpUrl = httpUrl + "/";
        }
        if (StringUtils.isNotBlank((String)httpUrl)) {
            SDKContext.wallet_url = httpUrl;
        }
    }

    public static void initTest(String httpUrl) {
        NulsSDKBootStrap.initChainId(2);
        if (httpUrl != null && !httpUrl.endsWith("/")) {
            httpUrl = httpUrl + "/";
        }
        if (StringUtils.isNotBlank((String)httpUrl)) {
            SDKContext.wallet_url = httpUrl;
        }
        SDKContext.addressPrefix = "tNULS";
    }

    private static void initChainId() {
        I18nUtils.loadLanguage(NulsSDKBootStrap.class, (String)LANGUAGE_PATH, (String)LANGUAGE);
    }

    private static void initChainId(int chainId) {
        if (chainId < 1 || chainId > 65535) {
            throw new RuntimeException("[defaultChainId] is invalid");
        }
        SDKContext.main_chain_id = chainId;
        if (chainId == 2) {
            SDKContext.addressPrefix = "tNULS";
        } else if (chainId > 2 && "NULS".equals(SDKContext.addressPrefix)) {
            SDKContext.addressPrefix = "";
        }
        try {
            Class.forName("io.nuls.core.exception.NulsException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

