/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.service;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Address;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.MapUtils;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.v2.SDKContext;
import io.nuls.v2.error.AccountErrorCode;
import io.nuls.v2.error.ContractErrorCode;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiType;
import io.nuls.v2.model.dto.AccountAmountDto;
import io.nuls.v2.model.dto.ContractCallForm;
import io.nuls.v2.model.dto.ContractConstructorInfoDto;
import io.nuls.v2.model.dto.ContractCreateForm;
import io.nuls.v2.model.dto.ContractDeleteForm;
import io.nuls.v2.model.dto.ContractMethodForm;
import io.nuls.v2.model.dto.ContractTokenTransferForm;
import io.nuls.v2.model.dto.ContractTransferForm;
import io.nuls.v2.model.dto.ContractValidateCallForm;
import io.nuls.v2.model.dto.ContractValidateCreateForm;
import io.nuls.v2.model.dto.ContractValidateDeleteForm;
import io.nuls.v2.model.dto.ContractViewCallForm;
import io.nuls.v2.model.dto.ImputedGasContractCallForm;
import io.nuls.v2.model.dto.ImputedGasContractCreateForm;
import io.nuls.v2.model.dto.ProgramMultyAssetValue;
import io.nuls.v2.model.dto.RestFulResult;
import io.nuls.v2.model.dto.RpcResult;
import io.nuls.v2.model.dto.RpcResultError;
import io.nuls.v2.tx.CallContractTransaction;
import io.nuls.v2.tx.CreateContractTransaction;
import io.nuls.v2.tx.DeleteContractTransaction;
import io.nuls.v2.txdata.CallContractData;
import io.nuls.v2.txdata.CreateContractData;
import io.nuls.v2.txdata.DeleteContractData;
import io.nuls.v2.util.AccountTool;
import io.nuls.v2.util.ContractUtil;
import io.nuls.v2.util.JsonRpcUtil;
import io.nuls.v2.util.ListUtil;
import io.nuls.v2.util.RestFulUtil;
import io.nuls.v2.util.ValidateUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(type=ApiType.SDK)
public class ContractService {
    private static ContractService instance = new ContractService();

    public static ContractService getInstance() {
        return instance;
    }

    @Parameters(value={@Parameter(parameterName="sender", parameterDes="\u4ea4\u6613\u521b\u5efa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8d26\u6237nonce\u503c"), @Parameter(parameterName="alias", parameterDes="\u5408\u7ea6\u522b\u540d"), @Parameter(parameterName="contractCode", parameterDes="\u667a\u80fd\u5408\u7ea6\u4ee3\u7801(\u5b57\u8282\u7801\u7684Hex\u7f16\u7801\u5b57\u7b26\u4e32)"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="\u53c2\u6570\u5217\u8868", canNull=true), @Parameter(parameterName="argsType", requestType=@TypeDescriptor(value=String[].class), parameterDes="\u53c2\u6570\u7c7b\u578b\u5217\u8868", canNull=true), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap\u5bf9\u8c61", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32"), @Key(name="contractAddress", description="\u751f\u6210\u7684\u5408\u7ea6\u5730\u5740")}))
    public Result<Map> createContractTxOffline(String sender, BigInteger senderBalance, String nonce, String alias, String contractCode, long gasLimit, Object[] args, String[] argsType, String remark) {
        int chainId = SDKContext.main_chain_id;
        if (!AddressTool.validAddress((int)chainId, (String)sender)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("sender [%s] is invalid", sender));
        }
        if (!FormatValidUtils.validAlias((String)alias)) {
            return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_ALIAS_FORMAT_ERROR).setMsg(String.format("alias [%s] is invalid", alias));
        }
        if (StringUtils.isBlank((String)contractCode)) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.NULL_PARAMETER).setMsg("contractCode is empty");
        }
        int assetChainId = SDKContext.main_chain_id;
        int assetId = SDKContext.main_asset_id;
        Address contract = AccountTool.createContractAddress(chainId);
        byte[] contractAddressBytes = contract.getAddressBytes();
        String[][] finalArgs = null;
        if (args != null && args.length > 0) {
            if (argsType == null || argsType.length != args.length) {
                return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("size of 'argsType' array not match 'args' array");
            }
            finalArgs = ContractUtil.twoDimensionalArray(args, argsType);
        }
        byte[] contractCodeBytes = HexUtil.decode((String)contractCode);
        byte[] senderBytes = AddressTool.getAddress((String)sender);
        CreateContractData createContractData = new CreateContractData();
        createContractData.setSender(senderBytes);
        createContractData.setContractAddress(contractAddressBytes);
        createContractData.setGasLimit(gasLimit);
        createContractData.setPrice(25L);
        createContractData.setCode(contractCodeBytes);
        createContractData.setAlias(alias);
        if (finalArgs != null) {
            createContractData.setArgsCount((short)finalArgs.length);
            createContractData.setArgs(finalArgs);
        }
        CreateContractTransaction tx = ContractUtil.newCreateTx(chainId, assetId, senderBalance, nonce, createContractData, remark);
        try {
            HashMap<String, String> resultMap = new HashMap<String, String>(4);
            resultMap.put("hash", tx.getHash().toHex());
            resultMap.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            resultMap.put("contractAddress", AddressTool.getStringAddressByBytes((byte[])contractAddressBytes));
            return ContractUtil.getSuccess().setData(resultMap);
        }
        catch (IOException e) {
            return ContractUtil.getFailed().setMsg(e.getMessage());
        }
    }

    @Parameters(value={@Parameter(parameterName="sender", parameterDes="\u4ea4\u6613\u521b\u5efa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8d26\u6237nonce\u503c"), @Parameter(parameterName="value", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8c03\u7528\u8005\u5411\u5408\u7ea6\u5730\u5740\u8f6c\u5165\u7684\u4e3b\u7f51\u8d44\u4ea7\u91d1\u989d\uff0c\u6ca1\u6709\u6b64\u4e1a\u52a1\u65f6\u586bBigInteger.ZERO"), @Parameter(parameterName="contractAddress", parameterDes="\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="methodName", parameterDes="\u5408\u7ea6\u65b9\u6cd5"), @Parameter(parameterName="methodDesc", parameterDes="\u5408\u7ea6\u65b9\u6cd5\u63cf\u8ff0\uff0c\u82e5\u5408\u7ea6\u5185\u65b9\u6cd5\u6ca1\u6709\u91cd\u8f7d\uff0c\u5219\u6b64\u53c2\u6570\u53ef\u4ee5\u4e3a\u7a7a", canNull=true), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="\u53c2\u6570\u5217\u8868", canNull=true), @Parameter(parameterName="argsType", requestType=@TypeDescriptor(value=String[].class), parameterDes="\u53c2\u6570\u7c7b\u578b\u5217\u8868", canNull=true), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4", canNull=true), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true), @Parameter(parameterName="multyAssetValues", requestType=@TypeDescriptor(value=List.class, collectionElement=ProgramMultyAssetValue.class), parameterDes="\u8c03\u7528\u8005\u5411\u5408\u7ea6\u5730\u5740\u8f6c\u5165\u7684\u5176\u4ed6\u8d44\u4ea7\u91d1\u989d\uff0c\u6ca1\u6709\u6b64\u4e1a\u52a1\u65f6\u586b\u7a7a\uff0c\u89c4\u5219: [[<value>,<assetChainId>,<assetId>]]", canNull=true), @Parameter(parameterName="nulsValueToOthers", requestType=@TypeDescriptor(value=String[][].class), parameterDes="\u8c03\u7528\u8005\u5411\u5176\u4ed6\u8d26\u6237\u5730\u5740\u8f6c\u5165\u7684NULS\u8d44\u4ea7\u91d1\u989d\uff0c\u6ca1\u6709\u6b64\u4e1a\u52a1\u65f6\u586b\u7a7a\uff0c\u89c4\u5219: [[<value>,<address>]]")})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public Result<Map> callContractTxOffline(String sender, BigInteger senderBalance, String nonce, BigInteger value, String contractAddress, long gasLimit, String methodName, String methodDesc, Object[] args, String[] argsType, long time, String remark, List<ProgramMultyAssetValue> multyAssetValues, List<AccountAmountDto> nulsValueToOthers) {
        int chainId = SDKContext.main_chain_id;
        if (!AddressTool.validAddress((int)chainId, (String)sender)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("sender [%s] is invalid", sender));
        }
        if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("contractAddress [%s] is invalid", contractAddress));
        }
        if (StringUtils.isBlank((String)methodName)) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.NULL_PARAMETER).setMsg("methodName is empty");
        }
        if (value == null) {
            value = BigInteger.ZERO;
        }
        int assetChainId = SDKContext.main_chain_id;
        int assetId = SDKContext.main_asset_id;
        String[][] finalArgs = null;
        if (args != null && args.length > 0) {
            if (argsType == null || argsType.length != args.length) {
                return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("size of 'argsType' array not match 'args' array");
            }
            finalArgs = ContractUtil.twoDimensionalArray(args, argsType);
        }
        byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
        byte[] senderBytes = AddressTool.getAddress((String)sender);
        CallContractData callContractData = new CallContractData();
        callContractData.setContractAddress(contractAddressBytes);
        callContractData.setSender(senderBytes);
        callContractData.setValue(value);
        callContractData.setPrice(25L);
        callContractData.setGasLimit(gasLimit);
        callContractData.setMethodName(methodName);
        callContractData.setMethodDesc(methodDesc);
        if (finalArgs != null) {
            callContractData.setArgsCount((short)finalArgs.length);
            callContractData.setArgs(finalArgs);
        }
        CallContractTransaction tx = ContractUtil.newCallTx(chainId, assetId, senderBalance, nonce, callContractData, time, remark, multyAssetValues, nulsValueToOthers);
        try {
            HashMap<String, String> resultMap = new HashMap<String, String>(4);
            resultMap.put("hash", tx.getHash().toHex());
            resultMap.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return ContractUtil.getSuccess().setData(resultMap);
        }
        catch (IOException e) {
            return ContractUtil.getFailed().setMsg(e.getMessage());
        }
    }

    @Parameters(value={@Parameter(parameterName="sender", parameterDes="\u4ea4\u6613\u521b\u5efa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8d26\u6237nonce\u503c"), @Parameter(parameterName="contractAddress", parameterDes="\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public Result<Map> deleteContractTxOffline(String sender, BigInteger senderBalance, String nonce, String contractAddress, String remark) {
        int chainId = SDKContext.main_chain_id;
        if (!AddressTool.validAddress((int)chainId, (String)sender)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("sender [%s] is invalid", sender));
        }
        if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("contractAddress [%s] is invalid", contractAddress));
        }
        byte[] senderBytes = AddressTool.getAddress((String)sender);
        byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
        DeleteContractData deleteContractData = new DeleteContractData();
        deleteContractData.setContractAddress(contractAddressBytes);
        deleteContractData.setSender(senderBytes);
        int assetId = SDKContext.main_asset_id;
        DeleteContractTransaction tx = ContractUtil.newDeleteTx(chainId, assetId, senderBalance, nonce, deleteContractData, remark);
        try {
            HashMap<String, String> resultMap = new HashMap<String, String>(4);
            resultMap.put("hash", tx.getHash().toHex());
            resultMap.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return ContractUtil.getSuccess().setData(resultMap);
        }
        catch (IOException e) {
            return ContractUtil.getFailed().setMsg(e.getMessage());
        }
    }

    @Parameters(value={@Parameter(parameterName="fromAddress", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237nonce\u503c"), @Parameter(parameterName="toAddress", parameterDes="\u8f6c\u5165\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="contractAddress", parameterDes="token\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u7684token\u8d44\u4ea7\u91d1\u989d"), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public Result<Map> tokenTransferTxOffline(String fromAddress, BigInteger senderBalance, String nonce, String toAddress, String contractAddress, long gasLimit, BigInteger amount, String remark) {
        return this.tokenTransferTxOffline(fromAddress, senderBalance, nonce, toAddress, contractAddress, gasLimit, amount, 0L, remark);
    }

    @Parameters(value={@Parameter(parameterName="fromAddress", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237nonce\u503c"), @Parameter(parameterName="toAddress", parameterDes="\u8f6c\u5165\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="contractAddress", parameterDes="token\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u7684token\u8d44\u4ea7\u91d1\u989d"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8f6c\u51fa\u7684token\u8d44\u4ea7\u91d1\u989d"), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public Result<Map> tokenTransferTxOffline(String fromAddress, BigInteger senderBalance, String nonce, String toAddress, String contractAddress, long gasLimit, BigInteger amount, long time, String remark) {
        int chainId = SDKContext.main_chain_id;
        if (amount == null || amount.compareTo(BigInteger.ZERO) <= 0) {
            return Result.getFailed((ErrorCode)ContractErrorCode.PARAMETER_ERROR).setMsg(String.format("amount [%s] is invalid", amount));
        }
        if (!AddressTool.validAddress((int)chainId, (String)fromAddress)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("fromAddress [%s] is invalid", fromAddress));
        }
        if (!AddressTool.validAddress((int)chainId, (String)toAddress)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("toAddress [%s] is invalid", toAddress));
        }
        if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("contractAddress [%s] is invalid", contractAddress));
        }
        return this.callContractTxOffline(fromAddress, senderBalance, nonce, null, contractAddress, gasLimit, "transfer", null, new Object[]{toAddress, amount.toString()}, new String[]{"String", "BigInteger"}, time, remark, null, null);
    }

    @Parameters(value={@Parameter(parameterName="fromAddress", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237nonce\u503c"), @Parameter(parameterName="toAddress", parameterDes="\u8f6c\u5165\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u7684\u4e3b\u94fe\u8d44\u4ea7\u91d1\u989d"), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public Result<Map> transferToContractTxOffline(String fromAddress, BigInteger senderBalance, String nonce, String toAddress, long gasLimit, BigInteger amount, String remark) {
        int chainId = SDKContext.main_chain_id;
        if (amount == null || amount.compareTo(BigInteger.ZERO) <= 0) {
            return Result.getFailed((ErrorCode)ContractErrorCode.PARAMETER_ERROR).setMsg(String.format("amount [%s] is invalid", amount));
        }
        if (!AddressTool.validAddress((int)chainId, (String)fromAddress)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("fromAddress [%s] is invalid", fromAddress));
        }
        if (!AddressTool.validAddress((int)chainId, (String)toAddress)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("toAddress [%s] is invalid", toAddress));
        }
        return this.callContractTxOffline(fromAddress, senderBalance, nonce, amount, toAddress, gasLimit, "_payable", "() return void", null, null, System.currentTimeMillis() / 1000L, remark, null, null);
    }

    @Parameters(value={@Parameter(parameterName="fromAddress", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u5730\u5740"), @Parameter(parameterName="senderBalance", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237\u4f59\u989d"), @Parameter(parameterName="nonce", parameterDes="\u8f6c\u51fa\u8005\u8d26\u6237nonce\u503c"), @Parameter(parameterName="toAddress", parameterDes="\u8f6c\u5165\u7684\u5408\u7ea6\u5730\u5740(NERVE\u7f51\u7edc\u5730\u5740)"), @Parameter(parameterName="contractAddress", parameterDes="token\u5408\u7ea6\u5730\u5740"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="\u8bbe\u7f6e\u5408\u7ea6\u6267\u884c\u6d88\u8017\u7684gas\u4e0a\u9650"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="\u8f6c\u51fa\u7684\u8d44\u4ea7\u91d1\u989d"), @Parameter(parameterName="time", requestType=@TypeDescriptor(value=long.class), parameterDes="\u4ea4\u6613\u65f6\u95f4"), @Parameter(parameterName="remark", parameterDes="\u4ea4\u6613\u5907\u6ce8", canNull=true)})
    @ResponseData(name="\u8fd4\u56de\u503c", description="\u8fd4\u56de\u4e00\u4e2aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="\u4ea4\u6613hash"), @Key(name="txHex", description="\u4ea4\u6613\u5e8f\u5217\u5316\u5b57\u7b26\u4e32")}))
    public Result<Map> nrc20CrossChainTxOffline(String fromAddress, BigInteger senderBalance, String nonce, String toAddress, String contractAddress, long gasLimit, BigInteger amount, long time, String remark) {
        int chainId = SDKContext.main_chain_id;
        if (amount == null || amount.compareTo(BigInteger.ZERO) <= 0) {
            return Result.getFailed((ErrorCode)ContractErrorCode.PARAMETER_ERROR).setMsg(String.format("amount [%s] is invalid", amount));
        }
        if (!AddressTool.validAddress((int)chainId, (String)fromAddress)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("fromAddress [%s] is invalid", fromAddress));
        }
        if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_ERROR).setMsg(String.format("contractAddress [%s] is invalid", contractAddress));
        }
        BigInteger value = BigInteger.valueOf(10000000L);
        return this.callContractTxOffline(fromAddress, senderBalance, nonce, value, contractAddress, gasLimit, "transferCrossChain", null, new Object[]{toAddress, amount.toString()}, new String[]{"String", "BigInteger"}, time, remark, null, null);
    }

    public Result createContract(ContractCreateForm form) {
        Result result;
        ValidateUtil.validateChainId();
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        if (form.getGasLimit() < 0L) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg(String.format("gasLimit [%s] is invalid", form.getGasLimit()));
        }
        if (form.getPrice() < 0L) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg(String.format("price [%s] is invalid", form.getPrice()));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sender", form.getSender());
        params.put("gasLimit", form.getGasLimit());
        params.put("price", form.getPrice());
        params.put("password", form.getPassword());
        params.put("remark", form.getRemark());
        params.put("alias", form.getAlias());
        params.put("args", form.getArgs());
        params.put("contractCode", form.getContractCode());
        RestFulResult restFulResult = RestFulUtil.post("api/contract/create", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result callContract(ContractCallForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        if (form.getGasLimit() < 0L) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg(String.format("gasLimit [%s] is invalid", form.getGasLimit()));
        }
        if (form.getPrice() < 0L) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg(String.format("price [%s] is invalid", form.getPrice()));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sender", form.getSender());
        params.put("gasLimit", form.getGasLimit());
        params.put("price", form.getPrice());
        params.put("password", form.getPassword());
        params.put("remark", form.getRemark());
        params.put("contractAddress", form.getContractAddress());
        params.put("value", form.getValue());
        params.put("multyAssetValues", form.getMultyAssetValues());
        params.put("methodName", form.getMethodName());
        params.put("methodDesc", form.getMethodDesc());
        params.put("args", form.getArgs());
        RestFulResult restFulResult = RestFulUtil.post("api/contract/call", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result deleteContract(ContractDeleteForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sender", form.getSender());
        params.put("contractAddress", form.getContractAddress());
        params.put("password", form.getPassword());
        params.put("remark", form.getRemark());
        RestFulResult restFulResult = RestFulUtil.post("api/contract/delete", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result tokentransfer(ContractTokenTransferForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        if (form.getAmount() == null || form.getAmount().compareTo(BigInteger.ZERO) < 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("amount is invalid");
        }
        Map params = MapUtils.beanToMap((Object)form);
        RestFulResult restFulResult = RestFulUtil.post("api/contract/tokentransfer", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result transferTocontract(ContractTransferForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        if (form.getAmount() == null || form.getAmount().compareTo(BigInteger.ZERO) < 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("amount is invalid");
        }
        Map params = MapUtils.beanToMap((Object)form);
        RestFulResult restFulResult = RestFulUtil.post("api/contract/transfer2contract", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getTokenBalance(String contractAddress, String address) {
        Result result;
        if (address == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("[address] is invalid");
        }
        if (contractAddress == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("[contractAddress] is invalid");
        }
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/contract/balance/token/" + contractAddress + "/" + address);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getContractResult(String hash) {
        Result result;
        if (hash == null || !ValidateUtil.validHash(hash)) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("[hash] is invalid");
        }
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/contract/result/" + hash);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getContractInfo(String contractAddress) {
        Result result;
        if (contractAddress == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("[contractAddress] is invalid");
        }
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/contract/info/" + contractAddress);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result<ContractConstructorInfoDto> getConstructor(String contractCode) {
        if (StringUtils.isBlank((String)contractCode)) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.NULL_PARAMETER).setMsg("contractCode is empty");
        }
        int chainId = SDKContext.main_chain_id;
        RpcResult rpcResult = JsonRpcUtil.request("getContractConstructor", ListUtil.of(chainId, contractCode));
        RpcResultError rpcResultError = rpcResult.getError();
        if (rpcResultError != null) {
            return Result.getFailed((ErrorCode)ErrorCode.init((String)rpcResultError.getCode())).setMsg(rpcResultError.getMessage());
        }
        ContractConstructorInfoDto dto = new ContractConstructorInfoDto((Map)rpcResult.getResult());
        return ContractUtil.getSuccess().setData((Object)dto);
    }

    public Result getContractMethod(ContractMethodForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        if (!AddressTool.validAddress((int)SDKContext.main_chain_id, (String)form.getContractAddress())) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg(String.format("contractAddress [%s] is invalid", form.getContractAddress()));
        }
        if (StringUtils.isBlank((String)form.getMethodName())) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("methodName is empty");
        }
        Map params = MapUtils.beanToMap((Object)form);
        RestFulResult restFulResult = RestFulUtil.post("api/contract/method", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getContractMethodArgsTypes(ContractMethodForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        if (!AddressTool.validAddress((int)SDKContext.main_chain_id, (String)form.getContractAddress())) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg(String.format("contractAddress [%s] is invalid", form.getContractAddress()));
        }
        if (StringUtils.isBlank((String)form.getMethodName())) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("methodName is empty");
        }
        Map params = MapUtils.beanToMap((Object)form);
        RestFulResult restFulResult = RestFulUtil.post("api/contract/method/argstypes", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result validateContractCreate(ContractValidateCreateForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        if (form.getGasLimit() < 0L) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg(String.format("gasLimit [%s] is invalid", form.getGasLimit()));
        }
        if (form.getPrice() < 0L) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg(String.format("price [%s] is invalid", form.getPrice()));
        }
        Map params = MapUtils.beanToMap((Object)form);
        RestFulResult restFulResult = RestFulUtil.post("api/contract/validate/create", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result validateContractCall(ContractValidateCallForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        if (form.getGasLimit() < 0L) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg(String.format("gasLimit [%s] is invalid", form.getGasLimit()));
        }
        if (form.getPrice() < 0L) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg(String.format("price [%s] is invalid", form.getPrice()));
        }
        Map params = MapUtils.beanToMap((Object)form);
        RestFulResult restFulResult = RestFulUtil.post("api/contract/validate/call", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result validateContractDelete(ContractValidateDeleteForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        Map params = MapUtils.beanToMap((Object)form);
        RestFulResult restFulResult = RestFulUtil.post("api/contract/validate/delete", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result imputedContractCreateGas(ImputedGasContractCreateForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        Map params = MapUtils.beanToMap((Object)form);
        RestFulResult restFulResult = RestFulUtil.post("api/contract/imputedgas/create", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result imputedContractCallGas(ImputedGasContractCallForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        Map params = MapUtils.beanToMap((Object)form);
        RestFulResult restFulResult = RestFulUtil.post("api/contract/imputedgas/call", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result invokeView(ContractViewCallForm form) {
        Result result;
        if (form == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR).setMsg("form data is empty");
        }
        Map params = MapUtils.beanToMap((Object)form);
        RestFulResult restFulResult = RestFulUtil.post("api/contract/view", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }
}

