/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.util;

import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.v2.SDKContext;
import io.nuls.v2.model.dto.RestFulResult;
import io.nuls.v2.util.HttpClientUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class RestFulUtil {
    public static RestFulResult<Map<String, Object>> get(String url) {
        return RestFulUtil.get(url, null);
    }

    public static RestFulResult<Map<String, Object>> get(String url, Map<String, Object> params) {
        try {
            url = SDKContext.wallet_url + url;
            String resultStr = HttpClientUtil.get(url, params);
            RestFulResult result = RestFulUtil.toResult(resultStr);
            return result;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return RestFulResult.failed(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage(), null);
        }
    }

    public static RestFulResult<List<Object>> getList(String url, Map<String, Object> params) {
        try {
            url = SDKContext.wallet_url + url;
            String resultStr = HttpClientUtil.get(url, params);
            RestFulResult result = RestFulUtil.toResultList(resultStr);
            return result;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return RestFulResult.failed(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage(), null);
        }
    }

    public static RestFulResult post(String url, Map<String, Object> params) {
        try {
            url = SDKContext.wallet_url + url;
            String resultStr = HttpClientUtil.post(url, params);
            RestFulResult result = RestFulUtil.toResult(resultStr);
            return result;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return RestFulResult.failed(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage(), null);
        }
    }

    public static RestFulResult<Map<String, Object>> put(String url, Map<String, Object> params) {
        try {
            url = SDKContext.wallet_url + url;
            String resultStr = HttpClientUtil.put(url, params);
            RestFulResult result = RestFulUtil.toResult(resultStr);
            return result;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return RestFulResult.failed(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage(), null);
        }
    }

    private static RestFulResult toResult(String str) throws IOException {
        Map resultMap = JSONUtils.json2map((String)str);
        RestFulResult result = null;
        Boolean b = (Boolean)resultMap.get("success");
        if (b.booleanValue()) {
            result = RestFulResult.success(resultMap.get("data"));
        } else {
            Object dataObj = resultMap.get("data");
            if (dataObj instanceof Map) {
                Map data = (Map)resultMap.get("data");
                if (data != null) {
                    result = RestFulResult.failed(data.get("code").toString(), data.get("msg").toString());
                }
            } else {
                result = RestFulResult.failed(CommonCodeConstanst.SYS_UNKOWN_EXCEPTION.getCode(), resultMap.toString());
            }
        }
        return result;
    }

    private static RestFulResult toResultList(String str) throws IOException {
        Map resultMap = JSONUtils.json2map((String)str);
        RestFulResult result = null;
        Boolean b = (Boolean)resultMap.get("success");
        if (b.booleanValue()) {
            List data = (List)resultMap.get("data");
            result = RestFulResult.success(data);
        } else {
            Map data = (Map)resultMap.get("data");
            if (data != null) {
                result = RestFulResult.failed(data.get("code").toString(), data.get("msg").toString());
            }
        }
        return result;
    }

    public static void main(String[] args) {
        RestFulResult<Map<String, Object>> result = RestFulUtil.get("api/accountledger/balance/tNULSeBaMt7c7sybfvP7iAC2p9d1ickHZvH9Sc");
        System.out.println(result.getData());
    }
}

