/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider;

import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.basic.AddressPrefixInf;
import io.nuls.base.basic.AddressTool;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Service;
import io.nuls.core.core.config.ConfigurationLoader;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.I18nUtils;
import io.nuls.core.rpc.info.HostInfo;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.modulebootstrap.NulsRpcModuleBootstrap;
import io.nuls.core.rpc.modulebootstrap.RpcModule;
import io.nuls.core.rpc.modulebootstrap.RpcModuleState;
import io.nuls.core.rpc.util.AddressPrefixDatas;
import io.nuls.provider.MyModule;
import io.nuls.provider.api.RpcServerManager;
import io.nuls.provider.api.cache.LedgerAssetCache;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.api.config.Context;
import io.nuls.v2.NulsSDKBootStrap;
import java.util.Map;

@Service
public class ApiBootstrap
extends RpcModule {
    private String moduleName = "nuls-api";
    @Autowired
    MyModule myModule;
    @Autowired
    private AddressPrefixDatas addressPrefixDatas;
    @Autowired
    private LedgerAssetCache ledgerAssetCache;
    @Autowired
    private Config config;

    public static void main(String[] args) {
        boolean isOffline = false;
        if (args == null || args.length == 0) {
            args = new String[]{"ws://" + HostInfo.getLocalIP() + ":7771"};
        } else {
            String arg1 = args[0];
            if (StringUtils.isNotBlank((String)arg1)) {
                arg1 = arg1.trim().toLowerCase();
            }
            if ("offline".equals(arg1)) {
                isOffline = true;
            }
        }
        String basePackage = "io.nuls";
        ConfigurationLoader configurationLoader = new ConfigurationLoader();
        configurationLoader.load();
        int defaultChainId = Integer.parseInt(configurationLoader.getValue("chainId"));
        Provider.ProviderType providerType = Provider.ProviderType.RPC;
        ServiceManager.init((Integer)defaultChainId, (Provider.ProviderType)providerType);
        Map configItemMap = (Map)configurationLoader.getConfigData().get("nuls-api");
        ConfigurationLoader.ConfigItem offline = (ConfigurationLoader.ConfigItem)configItemMap.get("offline");
        if (offline != null) {
            isOffline = Boolean.parseBoolean(offline.getValue());
        }
        if (!isOffline) {
            NulsRpcModuleBootstrap.run((String)"io.nuls", (String[])args);
        } else {
            SpringLiteContext.init((String[])new String[]{basePackage});
        }
        ApiBootstrap.initRpcServer(configItemMap);
        if (null != configItemMap && configItemMap.get("accessLimit") != null) {
            Context.accessLimit = Boolean.parseBoolean(((ConfigurationLoader.ConfigItem)configItemMap.get("accessLimit")).getValue());
        }
        NulsSDKBootStrap.init((int)defaultChainId, (String)"");
        if (defaultChainId == 2) {
            Context.multicall = "tNULSeBaMwP81fGuNPRRSpKxLto1o1hQPnUTJQ";
        }
        try {
            I18nUtils.setLanguage((String)"en");
        }
        catch (NulsException e) {
            e.printStackTrace();
        }
    }

    private static void initRpcServer(Map<String, ConfigurationLoader.ConfigItem> configItemMap) {
        String server_ip = "0.0.0.0";
        int server_port = 18004;
        if (configItemMap != null) {
            ConfigurationLoader.ConfigItem serverPort;
            ConfigurationLoader.ConfigItem serverIp = configItemMap.get("serverIp");
            if (serverIp != null) {
                server_ip = serverIp.getValue();
            }
            if ((serverPort = configItemMap.get("serverPort")) != null) {
                server_port = Integer.parseInt(serverPort.getValue());
            }
        }
        RpcServerManager.getInstance().startServer(server_ip, server_port);
    }

    public Module[] declareDependent() {
        return new Module[]{new Module(ModuleE.NC.abbr, "1.0")};
    }

    public Module moduleInfo() {
        return new Module(this.moduleName, "1.0");
    }

    public boolean doStart() {
        AddressTool.init((AddressPrefixInf)this.addressPrefixDatas);
        return true;
    }

    public void onDependenciesReady(Module module) {
        Log.info((String)"dependencies [{}] ready", (Object[])new Object[]{module.getName()});
        if (ModuleE.NC.abbr.equals(module.getName())) {
            Log.info((String)"onDependenciesReady nuls cores");
            this.ledgerAssetCache.initial(this.config.getChainId());
        }
    }

    public RpcModuleState onDependenciesReady() {
        return this.myModule.startModule(this.moduleName);
    }

    public RpcModuleState onDependenciesLoss(Module dependenciesModule) {
        return RpcModuleState.Running;
    }
}

