/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api;

import io.nuls.provider.utils.Log;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.jersey.internal.guava.ThreadFactoryBuilder;
import org.glassfish.jersey.servlet.ServletContainer;

public class RpcServerManager {
    private static final RpcServerManager INSTANCE = new RpcServerManager();
    private HttpServer httpServer;

    private RpcServerManager() {
    }

    public static RpcServerManager getInstance() {
        return INSTANCE;
    }

    public void startServer(String ip, int port) {
        URI serverURI = UriBuilder.fromUri((String)("http://" + ip)).port(port).build(new Object[0]);
        WebappContext webappContext = new WebappContext("NULS-V2-SDK-PROVIDER-SERVER", "/");
        ServletRegistration servletRegistration = webappContext.addServlet("jersey-servlet", ServletContainer.class);
        servletRegistration.setInitParameter("javax.ws.rs.Application", "io.nuls.provider.api.config.NulsResourceConfig");
        servletRegistration.addMapping(new String[]{"/*"});
        this.httpServer = new HttpServer();
        NetworkListener listener = new NetworkListener("grizzly2", ip, port);
        TCPNIOTransport transport = listener.getTransport();
        ThreadPoolConfig workerPool = ThreadPoolConfig.defaultConfig().setCorePoolSize(4).setMaxPoolSize(4).setQueueLimit(1000).setThreadFactory(new ThreadFactoryBuilder().setNameFormat("grizzly-http-server-%d").build());
        transport.configureBlocking(false);
        transport.setSelectorRunnersCount(2);
        transport.setWorkerThreadPoolConfig(workerPool);
        transport.setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
        transport.setTcpNoDelay(true);
        listener.setSecure(false);
        this.httpServer.addListener(listener);
        ServerConfiguration config = this.httpServer.getServerConfiguration();
        config.setDefaultQueryEncoding(Charsets.UTF8_CHARSET);
        webappContext.deploy(this.httpServer);
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            this.httpServer.start();
            Log.info("http restFul server is started!url is " + serverURI.toString());
        }
        catch (IOException e) {
            Log.error(e);
            this.httpServer.shutdownNow();
        }
    }
}

