/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.cache;

import io.nuls.base.api.provider.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.api.model.AssetInfo;
import io.nuls.provider.rpctools.CrossChainTools;
import io.nuls.provider.rpctools.LegderTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class LedgerAssetCache {
    @Autowired
    private LegderTools legderTools;
    @Autowired
    private CrossChainTools crossChainTools;
    @Autowired
    private Config config;
    private long lastCrossAssetQueryRecordTime;
    private long minitus_2 = 120000L;
    private Map<String, AssetInfo> CACHE_MAP = new HashMap<String, AssetInfo>();

    public void initial(int chainId) {
        Result<Map> allAsset = this.legderTools.getAllAsset(chainId);
        List list = allAsset.getList();
        for (Map map : list) {
            int assetChainId = Integer.parseInt(map.get("assetChainId").toString());
            int assetId = Integer.parseInt(map.get("assetId").toString());
            int decimalPlace = Integer.parseInt(map.get("decimalPlace").toString());
            String symbol = map.get("assetSymbol").toString();
            String key = assetChainId + "_" + assetId;
            this.CACHE_MAP.put(key, new AssetInfo(assetChainId, assetId, symbol, decimalPlace));
        }
        this.lastCrossAssetQueryRecordTime = System.currentTimeMillis();
    }

    public AssetInfo getAssetInfo(int chainId, int assetId) {
        String key = chainId + "_" + assetId;
        AssetInfo dto = this.CACHE_MAP.get(key);
        if (dto == null) {
            if (chainId == this.config.getChainId()) {
                Result<AssetInfo> result = this.legderTools.getAsset(chainId, assetId);
                if (result.isSuccess()) {
                    dto = (AssetInfo)result.getData();
                }
            } else {
                List<AssetInfo> crossAssetInfos;
                long now = System.currentTimeMillis();
                if (now - this.lastCrossAssetQueryRecordTime > this.minitus_2 && (crossAssetInfos = this.crossChainTools.getRegisteredChainInfoList(this.config.getChainId())) != null) {
                    for (AssetInfo assetInfo : crossAssetInfos) {
                        String _key = assetInfo.getChainId() + "_" + assetInfo.getAssetId();
                        this.CACHE_MAP.put(_key, assetInfo);
                    }
                    dto = this.CACHE_MAP.get(key);
                    this.lastCrossAssetQueryRecordTime = now;
                }
            }
            if (dto == null) {
                return null;
            }
            this.CACHE_MAP.put(key, dto);
        }
        return dto;
    }
}

