/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.jsonrpc.controller;

import io.nuls.base.RPCUtil;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.block.BlockService;
import io.nuls.base.api.provider.block.facade.BlockHeaderData;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByHeightReq;
import io.nuls.base.api.provider.crosschain.CrossChainProvider;
import io.nuls.base.api.provider.crosschain.facade.CreateCrossTxReq;
import io.nuls.base.api.provider.transaction.TransferService;
import io.nuls.base.api.provider.transaction.facade.TransferReq;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Transaction;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Controller;
import io.nuls.core.core.annotation.RpcMethod;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.api.config.Context;
import io.nuls.provider.model.dto.TransactionDto;
import io.nuls.provider.model.jsonrpc.RpcErrorCode;
import io.nuls.provider.model.jsonrpc.RpcResult;
import io.nuls.provider.rpctools.ContractTools;
import io.nuls.provider.rpctools.TransactionTools;
import io.nuls.provider.utils.ResultUtil;
import io.nuls.provider.utils.Utils;
import io.nuls.provider.utils.VerifyUtils;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.model.annotation.ApiType;
import io.nuls.v2.model.dto.CoinFromDto;
import io.nuls.v2.model.dto.CoinToDto;
import io.nuls.v2.model.dto.CrossTransferTxFeeDto;
import io.nuls.v2.model.dto.MultiSignTransferDto;
import io.nuls.v2.model.dto.MultiSignTransferTxFeeDto;
import io.nuls.v2.model.dto.TransferDto;
import io.nuls.v2.model.dto.TransferTxFeeDto;
import io.nuls.v2.txdata.CallContractData;
import io.nuls.v2.txdata.CreateContractData;
import io.nuls.v2.txdata.DeleteContractData;
import io.nuls.v2.util.CommonValidator;
import io.nuls.v2.util.NulsSDKTool;
import io.nuls.v2.util.ValidateUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@Api(type=ApiType.JSONRPC)
public class TransactionController {
    @Autowired
    Config config;
    @Autowired
    private TransactionTools transactionTools;
    @Autowired
    private ContractTools contractTools;
    TransferService transferService = (TransferService)ServiceManager.get(TransferService.class);
    CrossChainProvider crossChainProvider = (CrossChainProvider)ServiceManager.get(CrossChainProvider.class);
    BlockService blockService = (BlockService)ServiceManager.get(BlockService.class);

    @RpcMethod(value="getTxHex")
    @ApiOperation(description="according tohashObtain transaction hex", order=301)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="hash", parameterDes="transactionhash")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=TransactionDto.class))
    public RpcResult getTxHex(List<Object> params) {
        String txHash;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            txHash = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[txHash] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.dataNotFound();
        }
        if (StringUtils.isBlank((String)txHash) || !ValidateUtil.validHash((String)txHash)) {
            return RpcResult.paramError("[txHash] is inValid");
        }
        io.nuls.base.api.provider.Result<String> result = this.transactionTools.getTxHex(chainId, txHash);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="getTx")
    @ApiOperation(description="according tohashObtain transactions", order=301)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="hash", parameterDes="transactionhash")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=TransactionDto.class))
    public RpcResult getTx(List<Object> params) {
        TransactionDto txDto;
        String txHash;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            txHash = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[txHash] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.dataNotFound();
        }
        if (StringUtils.isBlank((String)txHash) || !ValidateUtil.validHash((String)txHash)) {
            return RpcResult.paramError("[txHash] is inValid");
        }
        io.nuls.base.api.provider.Result<TransactionDto> result = this.transactionTools.getTx(chainId, txHash);
        if (result.isSuccess() && (txDto = (TransactionDto)result.getData()).getBlockHeight() >= 0L) {
            GetBlockHeaderByHeightReq req = new GetBlockHeaderByHeightReq(Long.valueOf(txDto.getBlockHeight()));
            req.setChainId(Integer.valueOf(chainId));
            io.nuls.base.api.provider.Result blockResult = this.blockService.getBlockHeaderByHeight(req);
            if (blockResult.isSuccess()) {
                txDto.setBlockHash(((BlockHeaderData)blockResult.getData()).getHash());
            }
        }
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="validateTx")
    @ApiOperation(description="Verify transactions", order=302, detailDesc="Verify transactions for offline assembly,Successful verification returns transactionhashvalue,Failure returns error message")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterDes="Transaction serialization string")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="transactionhash")}))
    public RpcResult validateTx(List<Object> params) {
        String txHex;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            txHex = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[txHex] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.dataNotFound();
        }
        if (StringUtils.isBlank((String)txHex)) {
            return RpcResult.paramError("[txHex] is inValid");
        }
        io.nuls.base.api.provider.Result result = this.transactionTools.validateTx(chainId, txHex);
        if (result.isSuccess()) {
            return RpcResult.success(result.getData());
        }
        return RpcResult.failed(ErrorCode.init((String)result.getStatus()), result.getMessage());
    }

    @RpcMethod(value="broadcastTx")
    @ApiOperation(description="Broadcasting transactions", order=303, detailDesc="Broadcast offline assembly transactions,Successfully returnedtrue,Failure returns error message")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterDes="Transaction serialization16Hexadecimal Strings")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful"), @Key(name="hash", description="transactionhash")}))
    public RpcResult broadcastTx(List<Object> params) {
        String txHex;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            txHex = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[txHex] is inValid");
        }
        try {
            if (!Context.isChainExist(chainId)) {
                return RpcResult.dataNotFound();
            }
            int type = Utils.extractTxTypeFromTx(txHex);
            io.nuls.base.api.provider.Result result = new io.nuls.base.api.provider.Result();
            switch (type) {
                case 15: {
                    Transaction tx = new Transaction();
                    tx.parse(new NulsByteBuffer(RPCUtil.decode((String)txHex)));
                    CreateContractData create = new CreateContractData();
                    create.parse(new NulsByteBuffer(tx.getTxData()));
                    RpcResult createArgsResult = this.validateContractArgs(create.getArgs());
                    if (createArgsResult.getError() != null) {
                        return createArgsResult;
                    }
                    result = this.contractTools.validateContractCreate(chainId, AddressTool.getStringAddressByBytes((byte[])create.getSender()), create.getGasLimit(), create.getPrice(), RPCUtil.encode((byte[])create.getCode()), create.getArgs());
                    break;
                }
                case 16: {
                    Transaction callTx = new Transaction();
                    callTx.parse(new NulsByteBuffer(RPCUtil.decode((String)txHex)));
                    CallContractData call = new CallContractData();
                    call.parse(new NulsByteBuffer(callTx.getTxData()));
                    RpcResult argsResult = this.validateContractArgs(call.getArgs());
                    if (argsResult.getError() != null) {
                        return argsResult;
                    }
                    String[][] multyAssetValues = Utils.extractMultyAssetInfoFromCallTransaction(call.getContractAddress(), callTx.getCoinDataInstance(), this.config.getChainId(), this.config.getAssetsId());
                    result = this.contractTools.validateContractCall(chainId, AddressTool.getStringAddressByBytes((byte[])call.getSender()), call.getValue(), call.getGasLimit(), call.getPrice(), AddressTool.getStringAddressByBytes((byte[])call.getContractAddress()), call.getMethodName(), call.getMethodDesc(), call.getArgs(), multyAssetValues);
                    break;
                }
                case 17: {
                    Transaction deleteTx = new Transaction();
                    deleteTx.parse(new NulsByteBuffer(RPCUtil.decode((String)txHex)));
                    DeleteContractData delete = new DeleteContractData();
                    delete.parse(new NulsByteBuffer(deleteTx.getTxData()));
                    result = this.contractTools.validateContractDelete(chainId, AddressTool.getStringAddressByBytes((byte[])delete.getSender()), AddressTool.getStringAddressByBytes((byte[])delete.getContractAddress()));
                    break;
                }
            }
            Map contractMap = (Map)result.getData();
            if (contractMap != null && Boolean.FALSE.equals(contractMap.get("success"))) {
                return RpcResult.failed(CommonCodeConstanst.DATA_ERROR, (String)contractMap.get("msg"));
            }
            result = this.transactionTools.newTx(chainId, txHex);
            if (result.isSuccess()) {
                return RpcResult.success(result.getData());
            }
            return RpcResult.failed(ErrorCode.init((String)result.getStatus()), result.getMessage());
        }
        catch (Exception e) {
            io.nuls.provider.utils.Log.error(e);
            return RpcResult.failed(RpcErrorCode.TX_PARSE_ERROR);
        }
    }

    private RpcResult validateContractArgs(String[][] args) {
        if (args == null || args.length == 0) {
            return RpcResult.success(null);
        }
        try {
            for (String[] arg : args) {
                if (arg == null || arg.length == 0) continue;
                for (String str : arg) {
                    if (this.checkSpaceArg(str)) continue;
                    return RpcResult.failed(RpcErrorCode.CONTRACT_VALIDATION_FAILED);
                }
            }
            return RpcResult.success(null);
        }
        catch (Exception e) {
            Log.error((String)"parse args error.", (Throwable)e);
            return RpcResult.failed(RpcErrorCode.CONTRACT_VALIDATION_FAILED);
        }
    }

    private boolean checkSpaceArg(String s) {
        if (s == null) {
            return true;
        }
        return s.length() == s.trim().length();
    }

    @RpcMethod(value="broadcastTxWithNoContractValidation")
    @ApiOperation(description="Broadcasting transactions(Not verifying contracts)", order=304, detailDesc="Broadcast offline assembly transactions(Not verifying contracts),Successfully returnedtrue,Failure returns error message")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterDes="Transaction serialization16Hexadecimal Strings")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful"), @Key(name="hash", description="transactionhash")}))
    public RpcResult broadcastTxWithNoContractValidation(List<Object> params) {
        String txHex;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            txHex = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[txHex] is inValid");
        }
        try {
            if (!Context.isChainExist(chainId)) {
                return RpcResult.dataNotFound();
            }
            io.nuls.base.api.provider.Result result = this.transactionTools.newTx(chainId, txHex);
            if (result.isSuccess()) {
                return RpcResult.success(result.getData());
            }
            return RpcResult.failed(ErrorCode.init((String)result.getStatus()), result.getMessage());
        }
        catch (Exception e) {
            io.nuls.provider.utils.Log.error(e);
            return RpcResult.failed(RpcErrorCode.TX_PARSE_ERROR);
        }
    }

    @RpcMethod(value="broadcastTxWithoutAnyValidation")
    @ApiOperation(description="Broadcasting transactions(Do not verify)", order=305, detailDesc="Broadcast offline assembly transactions(Do not verify),Successfully returnedtrue,Failure returns error message")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterDes="Transaction serialization16Hexadecimal Strings")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful"), @Key(name="hash", description="transactionhash")}))
    public RpcResult broadcastTxWithoutAnyValidation(List<Object> params) {
        String txHex;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            txHex = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[txHex] is inValid");
        }
        try {
            if (!Context.isChainExist(chainId)) {
                return RpcResult.dataNotFound();
            }
            io.nuls.base.api.provider.Result result = this.transactionTools.broadcastTxWithoutAnyValidation(chainId, txHex);
            if (result.isSuccess()) {
                return RpcResult.success(result.getData());
            }
            return RpcResult.failed(ErrorCode.init((String)result.getStatus()), result.getMessage());
        }
        catch (Exception e) {
            io.nuls.provider.utils.Log.error(e);
            return RpcResult.failed(RpcErrorCode.TX_PARSE_ERROR);
        }
    }

    @RpcMethod(value="transferOtherChainAsset")
    @ApiOperation(description="Single transfer", order=306, detailDesc="Initiate transfer transactions for a single account or asset,Transfer assets to other parallel chain assets within the chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="Asset Chainid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="assetid"), @Parameter(parameterName="address", parameterDes="Transfer account address"), @Parameter(parameterName="toAddress", parameterDes="Transfer to account address"), @Parameter(parameterName="password", parameterDes="Transfer account password"), @Parameter(parameterName="amount", parameterDes="Transfer amount"), @Parameter(parameterName="remark", parameterDes="Remarks")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash")}))
    public RpcResult transferOtherChainAsset(List<Object> params) {
        String remark;
        String amount;
        String password;
        String toAddress;
        String address;
        int assetId;
        int assetChainId;
        int chainId;
        VerifyUtils.verifyParams(params, 8);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            assetChainId = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[assetChainId] is inValid");
        }
        try {
            assetId = (Integer)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[assetId] is inValid");
        }
        try {
            address = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            toAddress = (String)params.get(4);
        }
        catch (Exception e) {
            return RpcResult.paramError("[toAddress] is inValid");
        }
        try {
            password = (String)params.get(5);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        try {
            amount = params.get(6).toString();
        }
        catch (Exception e) {
            return RpcResult.paramError("[amount] is inValid");
        }
        try {
            remark = (String)params.get(7);
        }
        catch (Exception e) {
            return RpcResult.paramError("[remark] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)toAddress)) {
            return RpcResult.paramError("[toAddress] is inValid");
        }
        if (!ValidateUtil.validateBigInteger((String)amount)) {
            return RpcResult.paramError("[amount] is inValid");
        }
        TransferReq.TransferReqBuilder builder = new TransferReq.TransferReqBuilder(Integer.valueOf(chainId), Integer.valueOf(assetId)).addForm(Integer.valueOf(assetChainId), Integer.valueOf(assetId), address, password, new BigInteger(amount)).addTo(Integer.valueOf(assetChainId), Integer.valueOf(assetId), toAddress, new BigInteger(amount)).setRemark(remark);
        io.nuls.base.api.provider.Result result = this.transferService.transfer(builder.build(new TransferReq()));
        if (result.isSuccess()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
            resultMap.put("hash", result.getData());
            return RpcResult.success(resultMap);
        }
        return RpcResult.failed(ErrorCode.init((String)result.getStatus()), result.getMessage());
    }

    @RpcMethod(value="transfer")
    @ApiOperation(description="Single in chain transfer", order=306, detailDesc="Initiate transfer transactions for a single account or asset")
    @Parameters(value={@Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="Asset Chainid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="assetid"), @Parameter(parameterName="address", parameterDes="Transfer account address"), @Parameter(parameterName="toAddress", parameterDes="Transfer to account address"), @Parameter(parameterName="password", parameterDes="Transfer account password"), @Parameter(parameterName="amount", parameterDes="Transfer amount"), @Parameter(parameterName="remark", parameterDes="Remarks")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash")}))
    public RpcResult transfer(List<Object> params) {
        String remark;
        String amount;
        String password;
        String toAddress;
        String address;
        int assetId;
        int chainId;
        VerifyUtils.verifyParams(params, 7);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            assetId = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[assetId] is inValid");
        }
        try {
            address = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            toAddress = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[toAddress] is inValid");
        }
        try {
            password = (String)params.get(4);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        try {
            amount = params.get(5).toString();
        }
        catch (Exception e) {
            return RpcResult.paramError("[amount] is inValid");
        }
        try {
            remark = (String)params.get(6);
        }
        catch (Exception e) {
            return RpcResult.paramError("[remark] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)toAddress)) {
            return RpcResult.paramError("[toAddress] is inValid");
        }
        if (!ValidateUtil.validateBigInteger((String)amount)) {
            return RpcResult.paramError("[amount] is inValid");
        }
        TransferReq.TransferReqBuilder builder = new TransferReq.TransferReqBuilder(this.config.getChainId(), Integer.valueOf(assetId)).addForm(Integer.valueOf(chainId), Integer.valueOf(assetId), address, password, new BigInteger(amount)).addTo(Integer.valueOf(chainId), Integer.valueOf(assetId), toAddress, new BigInteger(amount)).setRemark(remark);
        io.nuls.base.api.provider.Result result = this.transferService.transfer(builder.build(new TransferReq()));
        if (result.isSuccess()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
            resultMap.put("hash", result.getData());
            return RpcResult.success(resultMap);
        }
        return RpcResult.failed(ErrorCode.init((String)result.getStatus()), result.getMessage());
    }

    @RpcMethod(value="crossTransfer")
    @ApiOperation(description="Single cross chain transfer", order=306, detailDesc="Initiate cross chain transfer transactions for single account and single asset transactions")
    @Parameters(value={@Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="Asset Chainid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="assetid"), @Parameter(parameterName="address", parameterDes="Transfer account address"), @Parameter(parameterName="toAddress", parameterDes="Transfer to account address"), @Parameter(parameterName="password", parameterDes="Transfer account password"), @Parameter(parameterName="amount", parameterDes="Transfer amount"), @Parameter(parameterName="remark", parameterDes="Remarks")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash")}))
    public RpcResult crossTransfer(List<Object> params) {
        String remark;
        String amount;
        String password;
        String toAddress;
        String address;
        int assetId;
        int chainId;
        VerifyUtils.verifyParams(params, 7);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            assetId = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[assetId] is inValid");
        }
        try {
            address = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            toAddress = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[toAddress] is inValid");
        }
        try {
            password = (String)params.get(4);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        try {
            amount = params.get(5).toString();
        }
        catch (Exception e) {
            return RpcResult.paramError("[amount] is inValid");
        }
        try {
            remark = (String)params.get(6);
        }
        catch (Exception e) {
            return RpcResult.paramError("[remark] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!ValidateUtil.validateBigInteger((String)amount)) {
            return RpcResult.paramError("[amount] is inValid");
        }
        CreateCrossTxReq.CreateCrossTxReqBuilder builder = new CreateCrossTxReq.CreateCrossTxReqBuilder(this.config.getChainId()).addForm(Integer.valueOf(chainId), Integer.valueOf(assetId), address, password, new BigInteger(amount)).addTo(Integer.valueOf(chainId), Integer.valueOf(assetId), toAddress, new BigInteger(amount)).setRemark(remark);
        io.nuls.base.api.provider.Result result = this.crossChainProvider.createCrossTx(builder.build());
        if (result.isSuccess()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
            resultMap.put("hash", result.getData());
            return RpcResult.success(resultMap);
        }
        return RpcResult.failed(ErrorCode.init((String)result.getStatus()), result.getMessage());
    }

    @RpcMethod(value="createTransferTxOffline")
    @ApiOperation(description="Offline assembly transfer transaction", order=350, detailDesc="according toinputsandoutputsOffline assembly transfer transaction, used for single account or multi account transfer transactions.The transaction fee isinputsThe total amount of main assets in the Li Ben Chain, minusoutputsThe total amount of main assets in the Li Ben Chain")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="Transfer transaction form", requestType=@TypeDescriptor(value=TransferDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization16Hexadecimal Strings")}))
    public RpcResult createTransferTxOffline(List<Object> params) {
        String remark;
        String amount;
        ArrayList<CoinFromDto> froms = new ArrayList<CoinFromDto>();
        ArrayList<CoinToDto> tos = new ArrayList<CoinToDto>();
        try {
            List inputList = (List)params.get(0);
            for (Map map : inputList) {
                amount = map.get("amount").toString();
                map.put("amount", new BigInteger(amount));
                CoinFromDto fromDto = (CoinFromDto)JSONUtils.map2pojo((Map)map, CoinFromDto.class);
                froms.add(fromDto);
            }
        }
        catch (Exception e) {
            return RpcResult.paramError("[inputList] is inValid");
        }
        try {
            List outputList = (List)params.get(1);
            for (Map map : outputList) {
                amount = map.get("amount").toString();
                map.put("amount", new BigInteger(amount));
                CoinToDto toDto = (CoinToDto)JSONUtils.map2pojo((Map)map, CoinToDto.class);
                tos.add(toDto);
            }
        }
        catch (Exception e) {
            return RpcResult.paramError("[outputList] is inValid");
        }
        try {
            remark = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[remark] is inValid");
        }
        try {
            TransferDto transferDto = new TransferDto();
            transferDto.setInputs(froms);
            transferDto.setOutputs(tos);
            transferDto.setRemark(remark);
            CommonValidator.checkTransferDto((TransferDto)transferDto);
            Result result = NulsSDKTool.createTransferTxOffline((TransferDto)transferDto);
            if (result.isSuccess()) {
                return RpcResult.success(result.getData());
            }
            return RpcResult.failed(result.getErrorCode(), result.getMsg());
        }
        catch (NulsException e) {
            return RpcResult.failed(e.getErrorCode(), e.format());
        }
    }

    @RpcMethod(value="createCrossTxOffline")
    @ApiOperation(description="Offline assembly transfer transaction", order=350, detailDesc="according toinputsandoutputsOffline assembly of cross chain transfer transactions, used for single account or multi account cross chain transfer transactions.The transaction fee isinputsThe total amount of main assets in the Li Ben Chain, minusoutputsThe total amount of main assets in the Li Ben Chain, plus cross chain transfer fees\uff08NULS\uff09")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="Transfer transaction form", requestType=@TypeDescriptor(value=TransferDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization16Hexadecimal Strings")}))
    public RpcResult createCrossTxOffline(List<Object> params) {
        String remark;
        String amount;
        ArrayList<CoinFromDto> froms = new ArrayList<CoinFromDto>();
        ArrayList<CoinToDto> tos = new ArrayList<CoinToDto>();
        try {
            List inputList = (List)params.get(0);
            for (Map map : inputList) {
                amount = map.get("amount").toString();
                map.put("amount", new BigInteger(amount));
                CoinFromDto fromDto = (CoinFromDto)JSONUtils.map2pojo((Map)map, CoinFromDto.class);
                froms.add(fromDto);
            }
        }
        catch (Exception e) {
            return RpcResult.paramError("[inputList] is inValid");
        }
        try {
            List outputList = (List)params.get(1);
            for (Map map : outputList) {
                amount = map.get("amount").toString();
                map.put("amount", new BigInteger(amount));
                CoinToDto toDto = (CoinToDto)JSONUtils.map2pojo((Map)map, CoinToDto.class);
                tos.add(toDto);
            }
        }
        catch (Exception e) {
            return RpcResult.paramError("[outputList] is inValid");
        }
        try {
            remark = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[remark] is inValid");
        }
        try {
            TransferDto transferDto = new TransferDto();
            transferDto.setInputs(froms);
            transferDto.setOutputs(tos);
            transferDto.setRemark(remark);
            CommonValidator.checkTransferDto((TransferDto)transferDto);
            Result result = NulsSDKTool.createCrossTransferTxOffline((TransferDto)transferDto);
            if (result.isSuccess()) {
                return RpcResult.success(result.getData());
            }
            return RpcResult.failed(result.getErrorCode(), result.getMsg());
        }
        catch (NulsException e) {
            return RpcResult.failed(e.getErrorCode(), e.format());
        }
    }

    @RpcMethod(value="calcTransferTxFee")
    @ApiOperation(description="Calculate the transaction fee required for offline creation of transfer transactions", order=351)
    @Parameters(value={@Parameter(parameterName="TransferTxFeeDto", parameterDes="Transfer transaction fees", requestType=@TypeDescriptor(value=TransferTxFeeDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Transaction fees")}))
    public RpcResult calcTransferTxFee(List<Object> params) {
        String price;
        String remark;
        int toLength;
        int fromLength;
        int addressCount;
        try {
            addressCount = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[addressCount] is inValid");
        }
        try {
            fromLength = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[fromLength] is inValid");
        }
        try {
            toLength = (Integer)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[toLength] is inValid");
        }
        try {
            remark = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[remark] is inValid");
        }
        try {
            price = (String)params.get(4);
        }
        catch (Exception e) {
            return RpcResult.paramError("[price] is inValid");
        }
        if (!ValidateUtil.validateBigInteger((String)price)) {
            return RpcResult.paramError("[price] is inValid");
        }
        TransferTxFeeDto dto = new TransferTxFeeDto();
        dto.setAddressCount(addressCount);
        dto.setFromLength(fromLength);
        dto.setToLength(toLength);
        dto.setRemark(remark);
        dto.setPrice(new BigInteger(price));
        BigInteger fee = NulsSDKTool.calcTransferTxFee((TransferTxFeeDto)dto);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", fee.toString());
        return RpcResult.success(map);
    }

    @RpcMethod(value="calcCrossTxFee")
    @ApiOperation(description="Calculate the transaction fee required for offline creation of cross chain transfer transactions", order=351)
    @Parameters(value={@Parameter(parameterName="TransferTxFeeDto", parameterDes="Transfer transaction fees", requestType=@TypeDescriptor(value=TransferTxFeeDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Transaction fees")}))
    public RpcResult calcCrossTxFee(List<Object> params) {
        String remark;
        int toLength;
        int fromLength;
        int addressCount;
        try {
            addressCount = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[addressCount] is inValid");
        }
        try {
            fromLength = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[fromLength] is inValid");
        }
        try {
            toLength = (Integer)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[toLength] is inValid");
        }
        try {
            remark = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[remark] is inValid");
        }
        CrossTransferTxFeeDto dto = new CrossTransferTxFeeDto();
        dto.setAddressCount(addressCount);
        dto.setFromLength(fromLength);
        dto.setToLength(toLength);
        dto.setRemark(remark);
        BigInteger fee = NulsSDKTool.calcCrossTransferNulsTxFee((CrossTransferTxFeeDto)dto);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", fee.toString());
        return RpcResult.success(map);
    }

    @RpcMethod(value="createMultiSignTransferTxOffline")
    @ApiOperation(description="Offline assembly transfer transaction", order=352, detailDesc="according toinputsandoutputsOffline assembly transfer transaction, used for single account or multi account transfer transactions.The transaction fee isinputsThe total amount of main assets in the Li Ben Chain, minusoutputsThe total amount of main assets in the Li Ben Chain")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="Transfer transaction form", requestType=@TypeDescriptor(value=MultiSignTransferDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization16Hexadecimal Strings")}))
    public RpcResult createMultiSignTransferTxOffline(List<Object> params) {
        String remark;
        String amount;
        int minSigns;
        List pubKeys;
        ArrayList<CoinFromDto> froms = new ArrayList<CoinFromDto>();
        ArrayList<CoinToDto> tos = new ArrayList<CoinToDto>();
        try {
            pubKeys = (List)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[pubKeys] is inValid");
        }
        try {
            minSigns = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[minSigns] is inValid");
        }
        try {
            List inputList = (List)params.get(2);
            for (Map map : inputList) {
                amount = map.get("amount").toString();
                map.put("amount", new BigInteger(amount));
                CoinFromDto fromDto = (CoinFromDto)JSONUtils.map2pojo((Map)map, CoinFromDto.class);
                froms.add(fromDto);
            }
        }
        catch (Exception e) {
            return RpcResult.paramError("[inputList] is inValid");
        }
        try {
            List outputList = (List)params.get(3);
            for (Map map : outputList) {
                amount = map.get("amount").toString();
                map.put("amount", new BigInteger(amount));
                CoinToDto toDto = (CoinToDto)JSONUtils.map2pojo((Map)map, CoinToDto.class);
                tos.add(toDto);
            }
        }
        catch (Exception e) {
            return RpcResult.paramError("[outputList] is inValid");
        }
        try {
            remark = (String)params.get(4);
        }
        catch (Exception e) {
            return RpcResult.paramError("[remark] is inValid");
        }
        try {
            MultiSignTransferDto transferDto = new MultiSignTransferDto();
            transferDto.setPubKeys(pubKeys);
            transferDto.setMinSigns(minSigns);
            transferDto.setInputs(froms);
            transferDto.setOutputs(tos);
            transferDto.setRemark(remark);
            CommonValidator.checkMultiSignTransferDto((MultiSignTransferDto)transferDto);
            Result result = NulsSDKTool.createMultiSignTransferTxOffline((MultiSignTransferDto)transferDto);
            if (result.isSuccess()) {
                return RpcResult.success(result.getData());
            }
            return RpcResult.failed(result.getErrorCode(), result.getMsg());
        }
        catch (NulsException e) {
            return RpcResult.failed(e.getErrorCode(), e.format());
        }
    }

    @RpcMethod(value="calcMultiSignTransferTxFee")
    @ApiOperation(description="Calculate the transaction fee required for offline creation of transfer transactions", order=353)
    @Parameters(value={@Parameter(parameterName="MultiSignTransferTxFeeDto", parameterDes="Transfer transaction fees", requestType=@TypeDescriptor(value=MultiSignTransferTxFeeDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Transaction fees")}))
    public RpcResult calcMultiSignTransferTxFee(List<Object> params) {
        String price;
        String remark;
        int toLength;
        int fromLength;
        int pubKeyCount;
        try {
            pubKeyCount = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[addressCount] is inValid");
        }
        try {
            fromLength = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[fromLength] is inValid");
        }
        try {
            toLength = (Integer)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[toLength] is inValid");
        }
        try {
            remark = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[remark] is inValid");
        }
        try {
            price = (String)params.get(4);
        }
        catch (Exception e) {
            return RpcResult.paramError("[price] is inValid");
        }
        if (!ValidateUtil.validateBigInteger((String)price)) {
            return RpcResult.paramError("[price] is inValid");
        }
        MultiSignTransferTxFeeDto dto = new MultiSignTransferTxFeeDto();
        dto.setPubKeyCount(pubKeyCount);
        dto.setFromLength(fromLength);
        dto.setToLength(toLength);
        dto.setRemark(remark);
        dto.setPrice(new BigInteger(price));
        BigInteger fee = NulsSDKTool.calcMultiSignTransferTxFee((MultiSignTransferTxFeeDto)dto);
        HashMap<String, BigInteger> map = new HashMap<String, BigInteger>();
        map.put("value", fee);
        return RpcResult.success(map);
    }
}

