/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.resources;

import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.consensus.ConsensusProvider;
import io.nuls.base.api.provider.consensus.facade.CreateAgentReq;
import io.nuls.base.api.provider.consensus.facade.DepositToAgentReq;
import io.nuls.base.api.provider.consensus.facade.GetDepositListReq;
import io.nuls.base.api.provider.consensus.facade.GetStopAgentCoinDataReq;
import io.nuls.base.api.provider.consensus.facade.StopAgentReq;
import io.nuls.base.api.provider.consensus.facade.WithdrawReq;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.api.manager.BeanCopierManager;
import io.nuls.provider.model.ErrorData;
import io.nuls.provider.model.RpcClientResult;
import io.nuls.provider.model.dto.DepositInfoDto;
import io.nuls.provider.model.dto.RandomSeedDTO;
import io.nuls.provider.model.form.consensus.CreateAgentForm;
import io.nuls.provider.model.form.consensus.DepositForm;
import io.nuls.provider.model.form.consensus.GetStopAgentCoinDataForm;
import io.nuls.provider.model.form.consensus.RandomRawSeedCountForm;
import io.nuls.provider.model.form.consensus.RandomRawSeedHeightForm;
import io.nuls.provider.model.form.consensus.RandomSeedCountForm;
import io.nuls.provider.model.form.consensus.RandomSeedHeightForm;
import io.nuls.provider.model.form.consensus.StopAgentForm;
import io.nuls.provider.model.form.consensus.WithdrawForm;
import io.nuls.provider.rpctools.ConsensusTools;
import io.nuls.provider.utils.ResultUtil;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.model.dto.ConsensusDto;
import io.nuls.v2.model.dto.DepositDto;
import io.nuls.v2.model.dto.MultiSignConsensusDto;
import io.nuls.v2.model.dto.MultiSignDepositDto;
import io.nuls.v2.model.dto.MultiSignStopConsensusDto;
import io.nuls.v2.model.dto.MultiSignWithDrawDto;
import io.nuls.v2.model.dto.StopConsensusDto;
import io.nuls.v2.model.dto.WithDrawDto;
import io.nuls.v2.util.NulsSDKTool;
import io.nuls.v2.util.ValidateUtil;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/api/consensus")
@Component
@Api
public class ConsensusResource {
    @Autowired
    private Config config;
    ConsensusProvider consensusProvider = (ConsensusProvider)ServiceManager.get(ConsensusProvider.class);
    @Autowired
    private ConsensusTools consensusTools;

    @POST
    @Path(value="/agent")
    @Produces(value={"application/json"})
    @ApiOperation(description="Create consensus nodes", order=501)
    @Parameters(value={@Parameter(parameterName="CreateAgentForm", parameterDes="Create consensus node form", requestType=@TypeDescriptor(value=CreateAgentForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="transactionhash")}))
    public RpcClientResult createAgent(CreateAgentForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        CreateAgentReq req = new CreateAgentReq(form.getAgentAddress(), form.getPackingAddress(), form.getRewardAddress(), Integer.valueOf(form.getCommissionRate()), new BigInteger(form.getDeposit()), form.getPassword());
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.consensusProvider.createAgent(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/agent/stop")
    @Produces(value={"application/json"})
    @ApiOperation(description="Unregister consensus node", order=502)
    @Parameters(value={@Parameter(parameterName="StopAgentForm", parameterDes="Unregister Consensus Node Form", requestType=@TypeDescriptor(value=StopAgentForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="transactionhash")}))
    public RpcClientResult stopAgent(StopAgentForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        StopAgentReq req = new StopAgentReq(form.getAddress(), form.getPassword());
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.consensusProvider.stopAgent(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/agent/stopCoinData")
    @Produces(value={"application/json"})
    @ApiOperation(description="Unregister consensus nodecoinData", order=502)
    @Parameters(value={@Parameter(parameterName="StopAgentForm", parameterDes="Unregister Consensus Node Form", requestType=@TypeDescriptor(value=StopAgentForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=String.class))
    public RpcClientResult getStopAgentCoinData(GetStopAgentCoinDataForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        GetStopAgentCoinDataReq req = new GetStopAgentCoinDataReq(form.getAgentHash(), 1L);
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.consensusProvider.getStopAgentCoinData(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/deposit")
    @Produces(value={"application/json"})
    @ApiOperation(description="Entrusting participation in consensus", order=503)
    @Parameters(value={@Parameter(parameterName="DepositForm", parameterDes="Delegated Participation Consensus Form", requestType=@TypeDescriptor(value=DepositForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="transactionhash")}))
    public RpcClientResult depositToAgent(DepositForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        DepositToAgentReq req = new DepositToAgentReq(form.getAddress(), form.getAgentHash(), new BigInteger(form.getDeposit()), form.getPassword());
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.consensusProvider.depositToAgent(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/withdraw")
    @Produces(value={"application/json"})
    @ApiOperation(description="Exit consensus", order=504)
    @Parameters(value={@Parameter(parameterName="Exit consensus", parameterDes="Exit consensus form", requestType=@TypeDescriptor(value=WithdrawForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="transactionhash")}))
    public RpcClientResult withdraw(WithdrawForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        WithdrawReq req = new WithdrawReq(form.getAddress(), form.getTxHash(), form.getPassword());
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.consensusProvider.withdraw(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @GET
    @Path(value="/list/deposit/{agentHash}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Query the delegation consensus list of nodes", order=505)
    @Parameters(value={@Parameter(parameterName="agentHash", parameterDes="Create transactions for consensus nodeshash")})
    @ResponseData(name="Return value", description="Return the delegate consensus set", responseType=@TypeDescriptor(value=List.class, collectionElement=DepositInfoDto.class))
    public RpcClientResult getDepositList(@PathParam(value="agentHash") String agentHash) {
        List list;
        if (!ValidateUtil.validHash((String)agentHash)) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "agentHash is invalid"));
        }
        GetDepositListReq req = new GetDepositListReq();
        req.setChainId(this.config.getChainId());
        req.setPageNumber(1);
        req.setPageSize(300);
        req.setAgentHash(agentHash);
        io.nuls.base.api.provider.Result result = this.consensusProvider.getDepositList(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (result.isSuccess() && (list = result.getList()) != null && !list.isEmpty()) {
            List dtoList = list.stream().map(info -> {
                DepositInfoDto dto = new DepositInfoDto();
                BeanCopierManager.beanCopier(info, dto);
                return dto;
            }).collect(Collectors.toList());
            clientResult.setData(dtoList);
        }
        return clientResult;
    }

    @POST
    @Path(value="/random/seed/count")
    @Produces(value={"application/json"})
    @ApiOperation(description="Generate a random seed based on the maximum height and the number of original seeds and return it", order=506, detailDesc="Including maximum height backwards1000Find a specified number of original seeds within this block interval, aggregate them to generate a random seed, and return it")
    @Parameters(value={@Parameter(parameterName="RandomSeedCountForm", parameterDes="Random Seed Form", requestType=@TypeDescriptor(value=RandomSeedCountForm.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=RandomSeedDTO.class))
    public RpcClientResult getRandomSeedByCount(RandomSeedCountForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        try {
            Map resultMap = this.consensusTools.getRandomSeedByCount(this.config.getChainId(), form.getHeight(), form.getCount(), form.getAlgorithm());
            return RpcClientResult.getSuccess(resultMap);
        }
        catch (NulsRuntimeException e) {
            return ResultUtil.getNulsRuntimeExceptionRpcClientResult(e);
        }
    }

    @POST
    @Path(value="/random/seed/height")
    @Produces(value={"application/json"})
    @ApiOperation(description="Generate a random seed based on the height interval and return it", order=507, detailDesc="Find all valid original seeds within this block interval, summarize them to generate a random seed, and return it")
    @Parameters(value={@Parameter(parameterName="RandomSeedHeightForm", parameterDes="Random Seed Form", requestType=@TypeDescriptor(value=RandomSeedHeightForm.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=RandomSeedDTO.class))
    public RpcClientResult getRandomSeedByHeight(RandomSeedHeightForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        try {
            Map resultMap = this.consensusTools.getRandomSeedByHeight(this.config.getChainId(), form.getStartHeight(), form.getEndHeight(), form.getAlgorithm());
            return RpcClientResult.getSuccess(resultMap);
        }
        catch (NulsRuntimeException e) {
            return ResultUtil.getNulsRuntimeExceptionRpcClientResult(e);
        }
    }

    @POST
    @Path(value="/random/rawseed/count")
    @Produces(value={"application/json"})
    @ApiOperation(description="Find the original seed list based on the maximum height and the number of original seeds, and return it", order=508, detailDesc="Including maximum height backwards1000Find a specified number of original seeds within this block interval and return them")
    @Parameters(value={@Parameter(parameterName="RandomRawSeedCountForm", parameterDes="Original random seed form", requestType=@TypeDescriptor(value=RandomRawSeedCountForm.class))})
    @ResponseData(name="Original Seed List", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public RpcClientResult getRandomRawSeedsByCount(RandomRawSeedCountForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        try {
            List<String> resultList = this.consensusTools.getRandomRawSeedsByCount(this.config.getChainId(), form.getHeight(), form.getCount());
            return RpcClientResult.getSuccess(resultList);
        }
        catch (NulsRuntimeException e) {
            return ResultUtil.getNulsRuntimeExceptionRpcClientResult(e);
        }
    }

    @POST
    @Path(value="/random/rawseed/height")
    @Produces(value={"application/json"})
    @ApiOperation(description="Search for the original seed list based on the height interval and return it", order=509, detailDesc="Find all valid original seeds within this block interval and return them")
    @Parameters(value={@Parameter(parameterName="RandomRawSeedHeightForm", parameterDes="Original random seed form", requestType=@TypeDescriptor(value=RandomRawSeedHeightForm.class))})
    @ResponseData(name="Original Seed List", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public RpcClientResult getRandomRawSeedsByHeight(RandomRawSeedHeightForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        try {
            List<String> resultList = this.consensusTools.getRandomRawSeedsByHeight(this.config.getChainId(), form.getStartHeight(), form.getEndHeight());
            return RpcClientResult.getSuccess(resultList);
        }
        catch (NulsRuntimeException e) {
            return ResultUtil.getNulsRuntimeExceptionRpcClientResult(e);
        }
    }

    @POST
    @Path(value="/agent/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - Create consensus node transactions", order=550, detailDesc="The required assets for participating in consensus can be obtained through the query chain information interface(agentChainIdandagentAssetId)")
    @Parameters(value={@Parameter(parameterName="ConsensusDto", parameterDes="Offline creation of consensus node form", requestType=@TypeDescriptor(value=ConsensusDto.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult createAgentOffline(ConsensusDto form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        Result result = NulsSDKTool.createConsensusTxOffline((ConsensusDto)form);
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/agent/stop/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - Unregister consensus node transactions", order=551, detailDesc="Assembly transactionsStopDepositDtoInformation can be obtained by querying the delegated consensus list of nodes,inputofnonceValue can be empty")
    @Parameters(value={@Parameter(parameterName="StopConsensusDto", parameterDes="Offline logout consensus node form", requestType=@TypeDescriptor(value=StopConsensusDto.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult stopAgentOffline(StopConsensusDto form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        Result result = NulsSDKTool.createStopConsensusTxOffline((StopConsensusDto)form);
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/deposit/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - Entrusted participation in consensus trading", order=552, detailDesc="The required assets for participating in consensus can be obtained through the query chain information interface(agentChainIdandagentAssetId)")
    @Parameters(value={@Parameter(parameterName="DepositDto", parameterDes="Offline Delegation Participation Consensus Form", requestType=@TypeDescriptor(value=DepositDto.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult depositToAgentOffline(DepositDto form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        Result result = NulsSDKTool.createDepositTxOffline((DepositDto)form);
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/withdraw/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - Exit consensus trading", order=553, detailDesc="InterfaceinputData is entrusted for consensus tradingoutputdatanonceValue can be empty")
    @Parameters(value={@Parameter(parameterName="WithDrawDto", parameterDes="Offline exit consensus form", requestType=@TypeDescriptor(value=WithDrawDto.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult withdrawOffline(WithDrawDto form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        Result result = NulsSDKTool.createWithdrawDepositTxOffline((WithDrawDto)form);
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/multiSign/agent/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly of multiple signed accounts - Create consensus node transactions", order=554, detailDesc="The required assets for participating in consensus can be obtained through the query chain information interface(agentChainIdandagentAssetId)")
    @Parameters(value={@Parameter(parameterName="MultiSignConsensusDto", parameterDes="Offline creation of consensus node form for multiple account signatures", requestType=@TypeDescriptor(value=MultiSignConsensusDto.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult createMultiSignAgentOffline(MultiSignConsensusDto form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        Result result = NulsSDKTool.createMultiSignConsensusTx((MultiSignConsensusDto)form);
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/multiSign/deposit/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - Delegate multiple account signatures to participate in consensus trading", order=555, detailDesc="The required assets for participating in consensus can be obtained through the query chain information interface(agentChainIdandagentAssetId)")
    @Parameters(value={@Parameter(parameterName="MultiSignDepositDto", parameterDes="Multiple account offline delegation participation consensus form", requestType=@TypeDescriptor(value=MultiSignDepositDto.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult multiSignDepositToAgentOffline(MultiSignDepositDto form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        Result result = NulsSDKTool.createMultiSignDepositTxOffline((MultiSignDepositDto)form);
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/multiSign/withdraw/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - Sign multiple accounts to exit consensus transactions", order=556, detailDesc="InterfaceinputData is entrusted for consensus tradingoutputdatanonceValue can be empty")
    @Parameters(value={@Parameter(parameterName="WithDrawDto", parameterDes="Multiple account offline exit consensus form with multiple signatures", requestType=@TypeDescriptor(value=MultiSignWithDrawDto.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult MultiSignWithdrawOffline(MultiSignWithDrawDto form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        Result result = NulsSDKTool.createMultiSignWithdrawDepositTxOffline((MultiSignWithDrawDto)form);
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/multiSign/agent/stop/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - Multiple account cancellation consensus node transactions", order=557, detailDesc="Assembly transactionsStopDepositDtoInformation can be obtained by querying the delegated consensus list of nodes,inputofnonceValue can be empty")
    @Parameters(value={@Parameter(parameterName="StopConsensusDto", parameterDes="Multiple account offline cancellation consensus node form", requestType=@TypeDescriptor(value=MultiSignStopConsensusDto.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult multiSignStopAgentOffline(MultiSignStopConsensusDto form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        Result result = NulsSDKTool.createMultiSignStopConsensusTx((MultiSignStopConsensusDto)form);
        return ResultUtil.getRpcClientResult(result);
    }
}

