/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.rpctools;

import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.provider.api.model.AssetInfo;
import io.nuls.provider.rpctools.CallRpc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class CrossChainTools
implements CallRpc {
    public List<AssetInfo> getRegisteredChainInfoList(int chainId) {
        try {
            return this.callRpc(ModuleE.CC.abbr, "getRegisteredChainInfoList", new HashMap<String, Object>(), map -> {
                if (map == null) {
                    return null;
                }
                List resultList = (List)map.get("list");
                ArrayList<AssetInfo> assetList = new ArrayList<AssetInfo>();
                for (Map resultMap : resultList) {
                    List list;
                    int id = (Integer)resultMap.get("chainId");
                    if (id == chainId || (list = (List)resultMap.get("assetInfoList")) == null) continue;
                    for (Map assetMap : list) {
                        String symbol = assetMap.get("symbol").toString();
                        int decimals = Integer.parseInt(assetMap.get("decimalPlaces").toString());
                        int assetId = Integer.parseInt(assetMap.get("assetId").toString());
                        assetList.add(new AssetInfo(id, assetId, symbol, decimals));
                    }
                }
                return assetList;
            });
        }
        catch (NulsRuntimeException e) {
            return null;
        }
    }
}

