/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.task;

import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.util.RpcCall;
import io.nuls.provider.api.config.Context;
import io.nuls.provider.api.model.AssetInfo;
import io.nuls.provider.api.model.ChainInfo;
import io.nuls.provider.utils.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryChainInfoTask
implements Runnable {
    @Override
    public void run() {
        if (Context.isRunCrossChain) {
            this.queryRegisteredChainInfoList();
        }
    }

    public void queryRegisteredChainInfoList() {
        try {
            Map map = (Map)RpcCall.request((String)ModuleE.CC.abbr, (String)"getRegisteredChainInfoList", new HashMap());
            List resultList = (List)map.get("list");
            ArrayList<ChainInfo> chainInfoList = new ArrayList<ChainInfo>();
            ArrayList<AssetInfo> assetInfoList = new ArrayList<AssetInfo>();
            for (Map resultMap : resultList) {
                ChainInfo chainInfo = new ChainInfo();
                chainInfo.setChainId((Integer)resultMap.get("chainId"));
                chainInfo.setChainName((String)resultMap.get("chainName"));
                List assetList = (List)resultMap.get("assetInfoList");
                if (assetList != null) {
                    for (Map assetMap : assetList) {
                        AssetInfo assetInfo = new AssetInfo();
                        assetInfo.setChainId((Integer)resultMap.get("chainId"));
                        assetInfo.setAssetId((Integer)assetMap.get("assetId"));
                        assetInfo.setSymbol((String)assetMap.get("symbol"));
                        assetInfo.setDecimals((Integer)assetMap.get("decimalPlaces"));
                        chainInfo.getAssets().add(assetInfo);
                        assetInfoList.add(assetInfo);
                    }
                }
                chainInfoList.add(chainInfo);
            }
            Context.chainList = chainInfoList;
            Context.assetList = assetInfoList;
        }
        catch (NulsException e) {
            Log.error(e);
        }
    }
}

