/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.utils;

import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.provider.model.ErrorData;
import io.nuls.provider.model.RpcClientResult;
import io.nuls.provider.model.jsonrpc.RpcResult;
import io.nuls.provider.model.jsonrpc.RpcResultError;

public class ResultUtil {
    public static RpcClientResult getRpcClientResult(io.nuls.base.api.provider.Result result) {
        if (result.isFailed()) {
            return RpcClientResult.getFailed(new ErrorData(result.getStatus(), result.getMessage()));
        }
        Object obj = result.getData();
        if (obj == null && (obj = result.getList()) == null) {
            obj = null;
        }
        if (obj != null) {
            return RpcClientResult.getSuccess(obj);
        }
        return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.DATA_NOT_FOUND.getCode(), CommonCodeConstanst.DATA_NOT_FOUND.getMsg()));
    }

    public static RpcClientResult getRpcClientResult(Result result) {
        if (result.isFailed()) {
            ErrorCode errorCode;
            String msg = result.getMsg();
            if (msg == null) {
                msg = "";
            }
            if ((errorCode = result.getErrorCode()) == null) {
                errorCode = CommonCodeConstanst.DATA_ERROR;
            }
            return RpcClientResult.getFailed(new ErrorData(errorCode.getCode(), errorCode.getMsg() + ";" + msg));
        }
        return RpcClientResult.getSuccess(result.getData());
    }

    public static RpcClientResult getNulsExceptionRpcClientResult(NulsException e) {
        ErrorCode errorCode = e.getErrorCode();
        if (errorCode != null) {
            return RpcClientResult.getFailed(new ErrorData(errorCode.getCode(), e.format()));
        }
        return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage()));
    }

    public static RpcClientResult getNulsRuntimeExceptionRpcClientResult(NulsRuntimeException e) {
        ErrorCode errorCode = e.getErrorCode();
        if (errorCode != null) {
            return RpcClientResult.getFailed(new ErrorData(errorCode.getCode(), e.format()));
        }
        return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage()));
    }

    public static io.nuls.base.api.provider.Result getNulsExceptionResult(NulsException e) {
        ErrorCode errorCode = e.getErrorCode();
        if (errorCode != null) {
            return io.nuls.base.api.provider.Result.fail((String)errorCode.getCode(), (String)e.format());
        }
        return io.nuls.base.api.provider.Result.fail((String)CommonCodeConstanst.DATA_ERROR.getCode(), (String)e.getMessage());
    }

    public static RpcResult getJsonRpcResult(io.nuls.base.api.provider.Result result) {
        RpcResult<Object> rpcResult = new RpcResult<Object>();
        if (result.isFailed()) {
            return rpcResult.setError(new RpcResultError(result.getStatus(), result.getMessage(), null));
        }
        Object obj = result.getData();
        if (obj == null && (obj = result.getList()) == null) {
            obj = null;
        }
        if (obj != null) {
            rpcResult.setResult(obj);
        } else {
            rpcResult.setError(new RpcResultError(CommonCodeConstanst.DATA_NOT_FOUND.getCode(), CommonCodeConstanst.DATA_NOT_FOUND.getMsg(), null));
        }
        return rpcResult;
    }

    public static RpcResult getJsonRpcResult(Result result) {
        RpcResult<Object> rpcResult = new RpcResult<Object>();
        if (result.isFailed()) {
            ErrorCode errorCode = result.getErrorCode();
            if (errorCode == null) {
                errorCode = CommonCodeConstanst.DATA_ERROR;
            }
            return rpcResult.setError(new RpcResultError(errorCode.getCode(), errorCode.getMsg(), result.getMsg()));
        }
        return rpcResult.setResult(result.getData());
    }

    public static RpcResult getNulsExceptionJsonRpcResult(NulsException e) {
        ErrorCode errorCode = e.getErrorCode();
        if (errorCode != null) {
            return RpcResult.failed(errorCode, e.format());
        }
        return RpcResult.failed(CommonCodeConstanst.DATA_ERROR, e.getMessage());
    }

    public static RpcResult getNulsRuntimeExceptionJsonRpcResult(NulsRuntimeException e) {
        ErrorCode errorCode = e.getErrorCode();
        if (errorCode != null) {
            return RpcResult.failed(errorCode, e.format());
        }
        return RpcResult.failed(CommonCodeConstanst.DATA_ERROR, e.getMessage());
    }
}

