/*
 * Decompiled with CFR 0.152.
 */
package net.steppschuh.markdowngenerator.rule;

import net.steppschuh.markdowngenerator.MarkdownElement;
import net.steppschuh.markdowngenerator.MarkdownSerializationException;
import net.steppschuh.markdowngenerator.util.StringUtil;

public class HorizontalRule
extends MarkdownElement {
    public static final char HYPHEN = '-';
    public static final char ASTERISK = '*';
    public static final char UNDERSCORE = '_';
    public static final int MINIMUM_LENGTH = 3;
    private int length;
    private char character = (char)45;

    public HorizontalRule() {
        this.length = 3;
    }

    public HorizontalRule(int length) {
        this.length = Math.max(3, length);
    }

    public HorizontalRule(int length, char character) {
        this(length);
        this.character = character;
    }

    @Override
    public String serialize() throws MarkdownSerializationException {
        return StringUtil.fillUpLeftAligned("", "" + this.character, this.length);
    }
}

