/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.NulsHash;
import io.nuls.base.signture.BlockSignature;
import io.nuls.core.basic.NulsData;
import io.nuls.core.crypto.UnsafeByteArrayOutputStream;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class BlockHeader
extends BaseNulsData {
    public static final Comparator<BlockHeader> BLOCK_HEADER_COMPARATOR = Comparator.comparingLong(BlockHeader::getHeight);
    private transient NulsHash hash;
    private NulsHash preHash;
    private NulsHash merkleHash;
    private long time;
    private long height;
    private int txCount;
    private BlockSignature blockSignature;
    private byte[] extend;
    private transient BlockExtendsData extendsData;
    private transient byte[] stateRoot;
    private transient byte[] packingAddress;

    private synchronized void calcHash() {
        if (null != this.hash) {
            return;
        }
        try {
            this.hash = NulsHash.calcHash(this.serializeWithoutSign());
        }
        catch (Exception e) {
            throw new NulsRuntimeException((Throwable)e);
        }
    }

    public int size() {
        int size = 0;
        size += 32;
        size += 32;
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfBytes((byte[])this.extend);
        return size += SerializeUtils.sizeOfNulsData((NulsData)this.blockSignature);
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.preHash.getBytes());
        stream.write(this.merkleHash.getBytes());
        stream.writeUint32(this.time);
        stream.writeUint32(this.height);
        stream.writeUint32(this.txCount);
        stream.writeBytesWithLength(this.extend);
        stream.writeNulsData(this.blockSignature);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.preHash = byteBuffer.readHash();
        this.merkleHash = byteBuffer.readHash();
        this.time = byteBuffer.readUint32();
        this.height = byteBuffer.readUint32();
        this.txCount = byteBuffer.readInt32();
        this.extend = byteBuffer.readByLengthByte();
        this.blockSignature = byteBuffer.readNulsData(new BlockSignature());
    }

    public byte[] serializeWithoutSign() {
        byte[] byArray;
        int size = this.size() - SerializeUtils.sizeOfNulsData((NulsData)this.blockSignature);
        UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream(size);
        try {
            NulsOutputStreamBuffer buffer = new NulsOutputStreamBuffer((OutputStream)bos);
            buffer.write(this.preHash.getBytes());
            buffer.write(this.merkleHash.getBytes());
            buffer.writeUint32(this.time);
            buffer.writeUint32(this.height);
            buffer.writeUint32(this.txCount);
            buffer.writeBytesWithLength(this.extend);
            byte[] bytes = bos.toByteArray();
            if (bytes.length != size) {
                throw new RuntimeException();
            }
            byArray = bytes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
        }
        bos.close();
        return byArray;
    }

    public NulsHash getHash() {
        if (null == this.hash) {
            this.calcHash();
        }
        return this.hash;
    }

    public BlockExtendsData getExtendsData() {
        if (this.extendsData == null) {
            this.extendsData = new BlockExtendsData(this.extend);
        }
        return this.extendsData;
    }

    public void setHash(NulsHash hash) {
        this.hash = hash;
    }

    public NulsHash getPreHash() {
        return this.preHash;
    }

    public void setPreHash(NulsHash preHash) {
        this.preHash = preHash;
    }

    public NulsHash getMerkleHash() {
        return this.merkleHash;
    }

    public void setMerkleHash(NulsHash merkleHash) {
        this.merkleHash = merkleHash;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public int getTxCount() {
        return this.txCount;
    }

    public void setTxCount(int txCount) {
        this.txCount = txCount;
    }

    public BlockSignature getBlockSignature() {
        return this.blockSignature;
    }

    public void setBlockSignature(BlockSignature scriptSign) {
        this.blockSignature = scriptSign;
    }

    public byte[] getPackingAddress(int chainId) {
        if (this.blockSignature != null && this.packingAddress == null) {
            this.packingAddress = AddressTool.getAddress(this.blockSignature.getPublicKey(), chainId);
        }
        return this.packingAddress;
    }

    public byte[] getExtend() {
        return this.extend;
    }

    public void setExtend(byte[] extend) {
        this.extend = extend;
    }

    public void setPackingAddress(byte[] packingAddress) {
        this.packingAddress = packingAddress;
    }

    public byte[] getStateRoot() {
        return this.stateRoot;
    }

    public void setStateRoot(byte[] stateRoot) {
        this.stateRoot = stateRoot;
    }

    public String toString() {
        return "BlockHeader{hash=" + this.hash.toHex() + ", preHash=" + this.preHash.toHex() + ", merkleHash=" + this.merkleHash.toHex() + ", time=" + this.time + ", height=" + this.height + ", txCount=" + this.txCount + ", blockSignature=" + this.blockSignature + ", size=" + this.size() + ", packingAddress=" + (Serializable)(this.packingAddress == null ? this.packingAddress : (byte[])AddressTool.getStringAddressByBytes(this.packingAddress)) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockHeader header = (BlockHeader)o;
        if (this.time != header.time) {
            return false;
        }
        if (this.height != header.height) {
            return false;
        }
        if (this.txCount != header.txCount) {
            return false;
        }
        if (!this.preHash.equals(header.preHash)) {
            return false;
        }
        if (!this.merkleHash.equals(header.merkleHash)) {
            return false;
        }
        if (!this.blockSignature.equals(header.blockSignature)) {
            return false;
        }
        return Arrays.equals(this.extend, header.extend);
    }

    public int hashCode() {
        int result = this.preHash.hashCode();
        result = 31 * result + this.merkleHash.hashCode();
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (int)(this.height ^ this.height >>> 32);
        result = 31 * result + this.txCount;
        result = 31 * result + this.blockSignature.hashCode();
        result = 31 * result + Arrays.hashCode(this.extend);
        return result;
    }
}

