/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.crypto.Sha256Hash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NulsHash {
    public static final int HASH_LENGTH = 32;
    private byte[] bytes;
    private String hex;

    public NulsHash() {
    }

    public NulsHash(byte[] bytes) {
        this.bytes = bytes;
        this.hex = null;
        if (bytes.length != 32) {
            throw new RuntimeException("the length is not eq 32 byte");
        }
    }

    public void parse(NulsByteBuffer buffer) throws NulsException {
        this.bytes = buffer.readBytes(32);
        this.hex = null;
    }

    public String toHex() {
        if (null == this.hex) {
            this.hex = HexUtil.encode((byte[])this.bytes);
        }
        return this.hex;
    }

    public static NulsHash fromHex(String hex) {
        byte[] bytes = HexUtil.decode((String)hex);
        return new NulsHash(bytes);
    }

    public static boolean validHash(String hex) {
        try {
            NulsHash.fromHex(hex);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean verify() {
        return this.getBytes() != null && this.getBytes().length == 32;
    }

    public static NulsHash calcHash(BaseNulsData data) {
        try {
            return NulsHash.calcHash(data.serialize());
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public static NulsHash calcHash(byte[] data) {
        NulsHash digestData = new NulsHash();
        digestData.bytes = Sha256Hash.hashTwice((byte[])data);
        return digestData;
    }

    public static NulsHash calcMerkleHash(List<NulsHash> hashList) {
        ArrayList<NulsHash> ddList = new ArrayList<NulsHash>(hashList);
        int levelOffset = 0;
        int levelSize = ddList.size();
        while (levelSize > 1) {
            for (int left = 0; left < levelSize; left += 2) {
                int right = Math.min(left + 1, levelSize - 1);
                byte[] leftBytes = ByteUtils.reverseBytes((byte[])((NulsHash)ddList.get(levelOffset + left)).getBytes());
                byte[] rightBytes = ByteUtils.reverseBytes((byte[])((NulsHash)ddList.get(levelOffset + right)).getBytes());
                byte[] whole = new byte[leftBytes.length + rightBytes.length];
                System.arraycopy(leftBytes, 0, whole, 0, leftBytes.length);
                System.arraycopy(rightBytes, 0, whole, leftBytes.length, rightBytes.length);
                NulsHash digest = NulsHash.calcHash(whole);
                ddList.add(digest);
            }
            levelOffset += levelSize;
            levelSize = (levelSize + 1) / 2;
        }
        byte[] bytes = ((NulsHash)ddList.get(ddList.size() - 1)).getBytes();
        Sha256Hash merkleHash = Sha256Hash.wrap((byte[])bytes);
        NulsHash digestData = new NulsHash();
        digestData.bytes = merkleHash.getBytes();
        return digestData;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NulsHash)) {
            return false;
        }
        NulsHash rhs = (NulsHash)obj;
        return Arrays.equals(this.bytes, rhs.getBytes());
    }

    public String toString() {
        return this.toHex();
    }
}

