/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.math.BigInteger;

public class NulsSignData
extends BaseNulsData {
    protected byte[] signBytes;

    public int size() {
        return SerializeUtils.sizeOfBytes((byte[])this.signBytes);
    }

    @Override
    public void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeBytesWithLength(this.signBytes);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.signBytes = byteBuffer.readByLengthByte();
    }

    public byte[] getSignBytes() {
        return this.signBytes;
    }

    public void setSignBytes(byte[] signBytes) {
        this.signBytes = signBytes;
    }

    public NulsSignData sign(NulsHash nulsHash, BigInteger privkey) throws NulsException {
        ECKey ecKey = ECKey.fromPrivate((BigInteger)privkey);
        byte[] signBytes = ecKey.sign(nulsHash.getBytes());
        NulsSignData signData = new NulsSignData();
        signData.parse(signBytes, 0);
        return signData;
    }

    public String toString() {
        try {
            return HexUtil.encode((byte[])this.serialize());
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            return super.toString();
        }
    }
}

