/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider.block;

import io.nuls.base.RPCUtil;
import io.nuls.base.api.provider.BaseRpcService;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.block.BlockService;
import io.nuls.base.api.provider.block.facade.BlockHeaderData;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByHashReq;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByHeightReq;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByLastHeightReq;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.po.BlockHeaderPo;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;

@Provider(value=Provider.ProviderType.RPC)
public class BlockServiceForRpc
extends BaseRpcService
implements BlockService {
    @Override
    public Result<BlockHeaderData> getBlockHeaderByHash(GetBlockHeaderByHashReq req) {
        return this._call("getBlockHeaderPoByHash", req, this::tranderBlockHeader);
    }

    @Override
    public Result<BlockHeaderData> getBlockHeaderByHeight(GetBlockHeaderByHeightReq req) {
        return this._call("getBlockHeaderPoByHeight", req, this::tranderBlockHeader);
    }

    @Override
    public Result<String> getBlockHexByHash(GetBlockHeaderByHashReq req) {
        return this.call("getBlockHexByHash", req, this::tranderString);
    }

    @Override
    public Result<String> getBlockHexByHeight(GetBlockHeaderByHeightReq req) {
        return this.call("getBlockHexByHeight", req, this::tranderString);
    }

    @Override
    public Result<BlockHeaderData> getBlockHeaderByLastHeight(GetBlockHeaderByLastHeightReq req) {
        return this._call("latestBlockHeaderPo", req, this::tranderBlockHeader);
    }

    @Override
    public Result rollback(GetBlockHeaderByHeightReq req) {
        return this._call("roll_back", req, this::tranderString);
    }

    @Override
    protected <T, R> Result<T> call(String method, Object req, Function<R, Result> res) {
        return this.callRpc(ModuleE.BL.abbr, method, req, res);
    }

    private Result<BlockHeaderData> _call(String method, Object req, Function<Map, Result> callback) {
        return this.call(method, req, callback);
    }

    private Result<String> tranderString(Map result) {
        String hexString = (String)result.get("value");
        if (StringUtils.isBlank((String)hexString)) {
            return this.success(null);
        }
        return this.success(hexString);
    }

    private Result<BlockHeaderData> tranderBlockHeader(Map result) {
        try {
            String hexString = (String)result.get("value");
            if (StringUtils.isBlank((String)hexString)) {
                return this.success(null);
            }
            BlockHeaderPo header = new BlockHeaderPo();
            header.parse(new NulsByteBuffer(RPCUtil.decode((String)hexString)));
            BlockHeaderData res = new BlockHeaderData();
            BlockExtendsData blockExtendsData = new BlockExtendsData();
            blockExtendsData.parse(new NulsByteBuffer(header.getExtend()));
            res.setHash(header.getHash().toString());
            res.setHeight(header.getHeight());
            res.setSize(header.getBlockSize());
            res.setTime(NulsDateUtils.timeStamp2DateStr((long)(header.getTime() * 1000L)));
            res.setTimestamp(header.getTime());
            res.setTxCount(header.getTxCount());
            res.setMerkleHash(header.getMerkleHash().toString());
            res.setBlockSignature(header.getBlockSignature().getSignData().toString());
            res.setPreHash(header.getPreHash().toString());
            res.setPackingAddress(AddressTool.getStringAddressByBytes((byte[])header.getPackingAddress(this.getChainId())));
            res.setConsensusMemberCount(blockExtendsData.getConsensusMemberCount());
            res.setMainVersion(blockExtendsData.getMainVersion());
            res.setBlockVersion(blockExtendsData.getBlockVersion());
            res.setPackingIndexOfRound(blockExtendsData.getPackingIndexOfRound());
            res.setRoundIndex(blockExtendsData.getRoundIndex());
            res.setRoundStartTime(NulsDateUtils.timeStamp2DateStr((long)(blockExtendsData.getRoundStartTime() * 1000L)));
            res.setRoundStartTimestamp(blockExtendsData.getRoundStartTime());
            res.setStateRoot(RPCUtil.encode((byte[])blockExtendsData.getStateRoot()));
            ArrayList<String> hashList = new ArrayList<String>();
            for (NulsHash nulsHash : header.getTxHashList()) {
                hashList.add(nulsHash.toHex());
            }
            res.setTxHashList(hashList);
            return this.success(res);
        }
        catch (NulsException e) {
            Log.error((String)"Deserializationblock headerexception occurred", (Throwable)e);
            return BlockServiceForRpc.fail(CommonCodeConstanst.DESERIALIZE_ERROR);
        }
    }
}

