/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider.contract;

import io.nuls.base.api.provider.BaseRpcService;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.contract.ContractProvider;
import io.nuls.base.api.provider.contract.facade.AccountContractInfo;
import io.nuls.base.api.provider.contract.facade.CallContractReq;
import io.nuls.base.api.provider.contract.facade.CreateContractReq;
import io.nuls.base.api.provider.contract.facade.DeleteContractReq;
import io.nuls.base.api.provider.contract.facade.GetAccountContractListReq;
import io.nuls.base.api.provider.contract.facade.GetContractConstructorArgsReq;
import io.nuls.base.api.provider.contract.facade.GetContractInfoReq;
import io.nuls.base.api.provider.contract.facade.GetContractResultReq;
import io.nuls.base.api.provider.contract.facade.GetContractTxReq;
import io.nuls.base.api.provider.contract.facade.TokenTransferReq;
import io.nuls.base.api.provider.contract.facade.TransferToContractReq;
import io.nuls.base.api.provider.contract.facade.ViewContractReq;
import io.nuls.core.parse.MapUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Provider(value=Provider.ProviderType.RPC)
public class ContractProviderForRpc
extends BaseRpcService
implements ContractProvider {
    @Override
    protected <T, R> Result<T> call(String method, Object req, Function<R, Result> callback) {
        return this.callRpc(ModuleE.SC.abbr, method, req, callback);
    }

    @Override
    public Result<Map> createContract(CreateContractReq req) {
        return this.callResutlMap("sc_create", req);
    }

    @Override
    public Result<Map> getContractConstructorArgs(GetContractConstructorArgsReq req) {
        return this.callResutlMap("sc_constructor", req);
    }

    @Override
    public Result<String> callContract(CallContractReq req) {
        return this.callReturnString("sc_call", req, "txHash");
    }

    @Override
    public Result<Map> viewContract(ViewContractReq req) {
        return this.callResutlMap("sc_invoke_view", req);
    }

    @Override
    public Result<String> deleteContract(DeleteContractReq req) {
        return this.callReturnString("sc_delete", req, "txHash");
    }

    @Override
    public Result<Map> getContractTx(GetContractTxReq req) {
        return this.callResutlMap("sc_contract_tx", req);
    }

    @Override
    public Result<Map> getContractResult(GetContractResultReq req) {
        return this.callResutlMap("sc_contract_result", req);
    }

    @Override
    public Result<Map> getContractInfo(GetContractInfoReq req) {
        return this.callResutlMap("sc_contract_info", req);
    }

    @Override
    public Result<String> transferToContract(TransferToContractReq req) {
        return this.callReturnString("sc_transfer", req, "txHash");
    }

    @Override
    public Result<String> tokenTransfer(TokenTransferReq req) {
        return this.callReturnString("sc_token_transfer", req, "txHash");
    }

    @Override
    public Result<AccountContractInfo> getAccountContractList(GetAccountContractListReq req) {
        Function<Map, Result> callback = res -> {
            List list = (List)res.get("list");
            List resData = list.stream().map(d -> {
                d.put("createTime", NulsDateUtils.timeStamp2DateStr((long)(Long.parseLong(String.valueOf(d.get("createTime"))) * 1000L)));
                return (AccountContractInfo)MapUtils.mapToBean((Map)d, (Object)new AccountContractInfo());
            }).collect(Collectors.toList());
            return this.success(resData);
        };
        return this.call("sc_account_contracts", req, callback);
    }

    private <T> Result<T> _call(String method, Object req, Function<Map, Result> callback) {
        return this.call(method, req, callback);
    }
}

