#!/bin/bash
MODULE_PATH=$(cd `dirname $0`;pwd)
cd "${MODULE_PATH}"


APP_NAME="nuls-cores" # %APP_NAME 注入
if [ -z "${APP_NAME}" ]; then
    echoRed "APP_NAME 未配置"
    exit 0;
fi

VERSION="1.0.0"; # %Version 注入
JAR_FILE="${MODULE_PATH}/${APP_NAME}-${VERSION}.jar"
MAIN_CLASS="io.nuls.NulsCoresBootstrap" # MAIN_CLASS 注入
JOPT_XMS="2048"  # JOPT_XMS 注入
JOPT_XMX="4096"    # JOPT_XMX 注入
JOPT_METASPACESIZE="128"  # %JOPT_METASPACESIZE 注入
JOPT_MAXMETASPACESIZE="256"  # %JOPT_MAXMETASPACESIZE 注入
JAVA_OPTS=""  # %JAVA_OPTS 注入

xmx=`echo $JOPT_XMX | awk -F, '{print $1}'`
if [ "$xmx" == "dynamic" ];
then
      totalMem=`free | awk '/Mem/ {print $2}'`
      if [ "$totalMem" -lt 8010000 ]
      then
          JOPT_XMX=3072
      else
          if [ "$totalMem" -lt 16000000 ];
          then
             JOPT_XMX=5120
          else
             JOPT_XMX=8192
          fi
      fi
fi

getModuleItem(){
    while read line
	do
		pname=`echo $line | awk -F '=' '{print $1}'`
		pvalue=`awk -v a="$line" '
						BEGIN{
							len = split(a,ary,"=")
							r=""
							for ( i = 2; i <= len; i++ ){
								if(r != ""){
									r = (r"=")
								}
								r=(r""ary[i])
					 		}
							print r
						}
					'`
		if [ "${pname}" == $2 ]; then
			echo ${pvalue};
			return 1;
		fi
	done < $1
	return 0
}

#获取绝对路径
function get_fullpath()
{
    if [ -f "$1" ];
    then
        tempDir=`dirname $1`;
        fileName=$1
        echo "`cd $tempDir; pwd`/${fileName##*/}";
    else
        echo `cd $1; pwd`;
    fi
}


echoRed() { echo -e $'\e[0;31m'$1$'\e[0m'; }
echoGreen() { echo -e $'\e[0;32m'$1$'\e[0m'; }
echoYellow() { echo -e $'\e[0;33m'$1$'\e[0m'; }
log(){
    now=`date "+%Y-%m-%d %H:%M:%S"`
    echo "${now}    $@" >> ${STDOUT_FILE}
    echoGreen "$@"
}
#获取参数
if [ ! -n "$1" ]; then 
    echo "args is error" 
    exit 0;
fi

while [ ! -z $1 ] ; do
    case "$1" in
        "--jre") 
            #log "jre path : $2"
            JAVA_HOME=$2
            shift 2 ;;
        "--managerurl") 
            #log "NulstarUrl is : $2"; 
            NulstarUrl=$2;    
            shift 2 ;;
        "-r")
            RESTART="1"
            shift 1 ;;
        "--config")
            config=$2;
            shift 2 ;;
        "--logpath")
            LOGS_DIR="$2/$APP_NAME"
            logpath="-Dlog.path=$2/$APP_NAME";
            shift 2 ;;
        "--loglevel")
            logLevel="-Dlog.level=$2";
            shift 2 ;;
        "--datapath")
            datapath="-DdataPath=$2";
            shift 2 ;;
        "--debug")
            DEBUG="$2";
            shift 2 ;;
        * )
            if [ -z "$2" ]; then
             shift 1
            fi
            shift 1 ;;
    esac
done

if [ ! -d $LOGS_DIR ]; then
    mkdir $LOGS_DIR
fi
START_DATE=`date +%Y%m%d%H%M%S`
STDOUT_FILE=$LOGS_DIR/stdout.log
if [ -z "${config}" ]; then
    config="../../../../nuls.ncf"
fi

_dataPath=`getModuleItem ${config} "dataPath"`
_logPath=`getModuleItem ${config} "logPath"`
_logLevel=`getModuleItem ${config} "logLevel"`
DEBUG=`getModuleItem ${config} "debug"`
cd `dirname ${config}`
if [ ! -d ${_dataPath} ]; then
    mkdir ${_dataPath}
fi
datapath="-DdataPath=`get_fullpath ${_dataPath}`"
if [ ! -d ${_logPath} ]; then
    mkdir ${_logPath}
fi
logpath="-Dlog.path=`get_fullpath ${_logPath}`/$APP_NAME";
logLevel="-Dlog.level=$_logLevel";
if [ -n "${LOG_LEVEL}" ]; then  #for env
   logLevel="-Dlog.level=$LOG_LEVEL";
fi
cd $MODULE_PATH

checkLogDir(){
    if [ ! -d ${LOGS_DIR} ]; then
        mkdir ${LOGS_DIR}
    fi
}

checkIsRunning(){
    if [ ! -z "`ps -ef|grep -w "${JAR_FILE} "|grep -v grep|awk '{print $2}'`" ]; then
        pid=`ps -ef|grep -w "${JAR_FILE} "|grep -v grep|awk '{print $2}'`

        if [ -n "${RESTART}" ];
        then
            log "$APP_NAME Already running pid=$pid";
            log "do restart ${APP_NAM}"
            log "stop ${APP_NAME}@${pid} failure,dump and kill it."
            kill $pid > /dev/null 2>&1
        else
            echoRed "$APP_NAME Already running pid=$pid";
            exit 0;
        fi
    fi
}


# 检查java版本
checkJavaVersion(){
    JAVA="$JAVA_HOME/bin/java"
    if [ ! -r "$JAVA" ]; then
        JAVA='java'
    fi

    JAVA_EXIST=`${JAVA} -version 2>&1 |grep 11`
    if [ ! -n "$JAVA_EXIST" ]; then
            log "JDK version is not 11"
            ${JAVA} -version
            exit 0
    fi
}

checkJavaVersion 
checkLogDir
checkIsRunning

#CLASSPATH=" -classpath ../../libs/*:./lib/*:${JAR_FILE}"
CLASSPATH=
if [ ! -f "./dependent.conf" ]; then
    echoRed "not found dependent config "
    exit 0
fi
while read line
do
    if [ -n $"CLASSPATH" ]; then
        CLASSPATH="${CLASSPATH}:"
    fi
    CLASSPATH="${CLASSPATH}../../libs/${line}"
done < ./dependent.conf
CLASSPATH=" -classpath ${CLASSPATH}:${JAR_FILE} "
JAVA_OPTS=" -server -XX:+UseG1GC -XX:MaxGCPauseMillis=50 -Xms${JOPT_XMS}m -Xmx${JOPT_XMX}m -XX:MetaspaceSize=${JOPT_METASPACESIZE}m -XX:MaxMetaspaceSize=${JOPT_MAXMETASPACESIZE}m -XX:+ParallelRefProcEnabled -XX:+TieredCompilation -XX:+ExplicitGCInvokesConcurrent $JAVA_OPTS"
JAVA_OPTS="${JAVA_OPTS} ${logpath} ${logLevel} ${datapath} "
JAVA_OOM_DUMP="-XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=${LOGS_DIR}/oom-${START_DATE}.hprof"
JAVA_OPTS="$JAVA_OPTS $JAVA_GC_LOG $JAVA_OOM_DUMP  -Dapp.name=$APP_NAME -Dactive.config=${config} "
echo "${JAVA} ${JAVA_OPTS} ${CLASSPATH} ${MAIN_CLASS} ${NulstarUrl}"
CMD="${JAVA} ${JAVA_OPTS} ${CLASSPATH} ${MAIN_CLASS} ${NulstarUrl} "
if [ "$DEBUG" == "1" ]; then
    CMD="${CMD} > ${STDOUT_FILE}"
fi
CMD="$CMD 2>&1 & ";
eval $CMD
#nohup ${JAVA} ${JAVA_OPTS} ${CLASSPATH} ${MAIN_CLASS} ${NulstarUrl} > ${STDOUT_FILE} 2>&1 &

log "${APP_NAME} IS STARTING \n ${APP_NAME} START CMD: $CMD  \n ${APP_NAME} 日志文件: ${STDOUT_FILE}"
# echo "${APP_NAME} start cmd:" $'\e[0;31m'${JAVA} ${JAVA_OPTS} ${CLASSPATH} ${MAIN_CLASS} ${NulstarUrl}$'\e[0m'
# echo "${APP_NAME} 日志文件: " $'\e[0;31m'${STDOUT_FILE}$'\e[0m'

